/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.java.editor.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.pattern.ui.editors.templateEditor.TemplateEditorUtility;
import org.eclipse.egf.pattern.ui.editors.templateEditor.computer.PatternParameterProposalComputer;
import org.eclipse.egf.pattern.ui.editors.templateEditor.computer.PatternVariableProposalComputer;
import org.eclipse.egf.pattern.ui.java.editor.JavaTextEditor;
import org.eclipse.egf.pattern.ui.java.editor.JavaTextEditorHelper;
import org.eclipse.egf.pattern.ui.java.editor.contentassist.computer.JavaTypeProposalComputer;
import org.eclipse.egf.pattern.ui.java.template.JavaTemplateEditor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTextEditorContentAssistProcessor
implements IContentAssistProcessor {
    private JavaTextEditor editor;
    private IEditorPart templateEditorPart;
    private Pattern pattern;
    private static final String JAVA_LANG_PAKAGE = "java.lang.";
    private static final String JAVA_UTIL_PAKAGE = "java.util.";
    private char[] fCompletionAutoActivationCharacters;

    public JavaTextEditorContentAssistProcessor(JavaTextEditor editor) {
        this.editor = editor;
        this.fCompletionAutoActivationCharacters = editor.getEditorPreferenceStore().getString("content_assist_autoactivation_triggers_java").toCharArray();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        MultiPageEditorPart multiPageEditorPart = JavaTextEditorHelper.getMultiPageEditorPart(this.editor);
        if (multiPageEditorPart == null) {
            return null;
        }
        this.templateEditorPart = ((JavaTemplateEditor)multiPageEditorPart).getTemplateFileEditorPart();
        this.refreshPublicTemplateEditor();
        this.pattern = this.editor.getPattern();
        ArrayList proposals = new ArrayList();
        PatternParameterProposalComputer parameterProposalComputer = new PatternParameterProposalComputer(viewer, offset, this.pattern);
        this.addProposal(proposals, parameterProposalComputer.computeProposal());
        PatternVariableProposalComputer variableProposalComputer = new PatternVariableProposalComputer(viewer, offset, this.pattern);
        this.addProposal(proposals, variableProposalComputer.computeProposal());
        int mappingOffset = JavaTextEditorHelper.getMappingOffset(this.pattern, this.editor, offset);
        JavaTypeProposalComputer javaTypeProposalComputer = new JavaTypeProposalComputer(viewer, mappingOffset, this.templateEditorPart);
        List<ICompletionProposal> computeProposals = javaTypeProposalComputer.computeProposal();
        List<ICompletionProposal> javaTypeProposals = this.updateProposalOffset(computeProposals, offset, mappingOffset);
        this.addProposal(proposals, javaTypeProposals);
        ICompletionProposal[] result = null;
        if (proposals.size() != 0) {
            result = new ICompletionProposal[proposals.size()];
            int i = 0;
            while (i < proposals.size()) {
                result[i] = (ICompletionProposal)proposals.get(i);
                ++i;
            }
        }
        return result;
    }

    private List<ICompletionProposal> updateProposalOffset(List<ICompletionProposal> computeProposals, int offset, int mappingOffset) {
        if (computeProposals == null) {
            return null;
        }
        ArrayList<ICompletionProposal> newProposals = new ArrayList<ICompletionProposal>();
        int activePageIndex = JavaTextEditorHelper.getActivePageIndex((ITextEditor)this.editor);
        for (ICompletionProposal computeProposal : computeProposals) {
            if (computeProposal instanceof AbstractJavaCompletionProposal) {
                AbstractJavaCompletionProposal currentPropsal = (AbstractJavaCompletionProposal)computeProposal;
                int replacementOffset = currentPropsal.getReplacementOffset() - (mappingOffset - offset);
                currentPropsal.setReplacementOffset(replacementOffset);
            }
            if (activePageIndex != 0 && computeProposal instanceof LazyGenericTypeProposal) {
                CompletionProposal javaProposal = this.changeLazyGenericTypeToJavaProposal(computeProposals, (LazyGenericTypeProposal)computeProposal);
                newProposals.add((ICompletionProposal)javaProposal);
                continue;
            }
            if (computeProposal instanceof TemplateProposal) {
                CompletionProposal templateProposal = this.changTemplateToJavaProposal(computeProposals, (TemplateProposal)computeProposal, offset);
                newProposals.add((ICompletionProposal)templateProposal);
                continue;
            }
            newProposals.add(computeProposal);
        }
        return newProposals;
    }

    private List<ICompletionProposal> reverseProposals(List<ICompletionProposal> computeProposals) {
        ArrayList<ICompletionProposal> newComputeProposals = new ArrayList<ICompletionProposal>();
        int i = computeProposals.size() - 1;
        while (i >= 0) {
            newComputeProposals.add(computeProposals.get(i));
            --i;
        }
        return newComputeProposals;
    }

    private CompletionProposal changeLazyGenericTypeToJavaProposal(List<ICompletionProposal> computeProposals, LazyGenericTypeProposal lazyGenericTypeProposal) {
        String replacementString = lazyGenericTypeProposal.getReplacementString();
        int replacementOffset = lazyGenericTypeProposal.getReplacementOffset();
        int replacementLength = lazyGenericTypeProposal.getReplacementLength();
        Image image = lazyGenericTypeProposal.getImage();
        String displayString = lazyGenericTypeProposal.getDisplayString();
        String qualifiedTypeName = lazyGenericTypeProposal.getQualifiedTypeName();
        if ((JAVA_LANG_PAKAGE + replacementString).equals(qualifiedTypeName) || (JAVA_UTIL_PAKAGE + replacementString).equals(qualifiedTypeName)) {
            qualifiedTypeName = replacementString;
        }
        CompletionProposal proposal = new CompletionProposal(qualifiedTypeName, replacementOffset, replacementLength, qualifiedTypeName.length(), image, displayString, null, null);
        return proposal;
    }

    private CompletionProposal changTemplateToJavaProposal(List<ICompletionProposal> computeProposals, TemplateProposal templateProposal, int offset) {
        String replaceString = templateProposal.getAdditionalProposalInfo();
        Image image = templateProposal.getImage();
        String displayString = templateProposal.getDisplayString();
        String[] allWords = TemplateEditorUtility.getAllWords((ITextViewer)this.editor.getViewer(), (int)offset);
        new ArrayList();
        if (allWords.length > 0) {
            String replacedWord = allWords[0];
            int replacementOffset = offset - replacedWord.length();
            CompletionProposal proposal = new CompletionProposal(replaceString, replacementOffset, replacedWord.length(), replaceString.length(), image, displayString, null, null);
            return proposal;
        }
        return null;
    }

    private void refreshPublicTemplateEditor() {
        IEditorInput editorInput = this.templateEditorPart.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFile templateFile = ((IFileEditorInput)editorInput).getFile();
            JavaTextEditorHelper.refreshPublicTemplateEditor(this.pattern, templateFile, this.editor);
        }
    }

    private void addProposal(List proposals, List newProposals) {
        if (newProposals != null && newProposals.size() != 0) {
            proposals.addAll(newProposals);
        }
    }

    public ICompilationUnit getCompilationUnit() {
        IEditorPart fEditor = null;
        if (fEditor == null) {
            return null;
        }
        ICompilationUnit fCU = null;
        ITypeRoot je = EditorUtility.getEditorInputJavaElement(fEditor, (boolean)false);
        if (je instanceof ICompilationUnit) {
            fCU = (ICompilationUnit)je;
        }
        return fCU;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fCompletionAutoActivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

