/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.java.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.pattern.ui.java.Activator;
import org.eclipse.egf.pattern.ui.java.editor.JavaDocumentReader;
import org.eclipse.egf.pattern.ui.java.editor.JavaTextEditor;
import org.eclipse.egf.pattern.ui.java.template.JavaTemplateEditor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.IProblemRequestorExtension;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTextEditorHelper {
    public static String[] getAllWords(char c, JavaDocumentReader reader) {
        ArrayList<String> all = new ArrayList<String>(20);
        char currChar = c;
        currChar = JavaTextEditorHelper.trimBlanksBackward(reader, currChar);
        boolean done = false;
        while (!done) {
            Stack<Character> stack = new Stack<Character>();
            while (currChar != '\uffff' && !Character.isWhitespace(currChar)) {
                stack.push(new Character(currChar));
                currChar = reader.readBackward();
            }
            String s = new String();
            while (!stack.empty()) {
                s = String.valueOf(s) + ((Character)stack.pop()).toString();
            }
            all.add(s);
            currChar = JavaTextEditorHelper.trimBlanksBackward(reader, currChar);
            if (currChar != '\uffff' && currChar != '@') continue;
            done = true;
        }
        return all.toArray(new String[all.size()]);
    }

    public static char trimBlanksBackward(JavaDocumentReader reader, char currChar) {
        while (currChar != '\uffff' && Character.isWhitespace(currChar)) {
            currChar = reader.readBackward();
        }
        return currChar;
    }

    public static void refreshPublicTemplateEditor(Pattern pattern, IFile templateFile, JavaTextEditor editor) {
        MultiPageEditorPart multiPageEditorPart = JavaTextEditorHelper.getMultiPageEditorPart(editor);
        List editors = ((JavaTemplateEditor)multiPageEditorPart).getEditorList();
        if (templateFile.exists()) {
            try {
                templateFile.setContents((InputStream)new ByteArrayInputStream(new byte[0]), true, false, null);
                if (editors == null) {
                    return;
                }
                int size = editors.size();
                if (size == 0) {
                    return;
                }
                JavaTextEditor footerEditor = null;
                int i = 0;
                while (i < size) {
                    JavaTextEditor currentEditor = (JavaTextEditor)((Object)editors.get(i));
                    String partName = currentEditor.getPartName();
                    if (partName.equals("footer")) {
                        footerEditor = currentEditor;
                    } else {
                        JavaTextEditorHelper.visitMethod(currentEditor, templateFile, true);
                    }
                    ++i;
                }
                JavaTextEditorHelper.visitMethod(footerEditor, templateFile, false);
            }
            catch (Exception exception) {}
        } else {
            try {
                templateFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
            }
            catch (CoreException e) {
                Activator.getDefault();
                Activator.log((Exception)((Object)e));
            }
            JavaTextEditorHelper.refreshPublicTemplateEditor(pattern, templateFile, editor);
        }
    }

    private static void visitMethod(JavaTextEditor currentEditor, IFile templateFile, boolean seprator) throws CoreException {
        if (currentEditor == null) {
            return;
        }
        if (currentEditor != null) {
            InputStream inputStreamOfEditor = JavaTextEditorHelper.getInputStreamOfEditor(currentEditor);
            if (inputStreamOfEditor == null) {
                return;
            }
            templateFile.appendContents(inputStreamOfEditor, false, false, null);
            if (seprator) {
                templateFile.appendContents((InputStream)new StringBufferInputStream("\n"), true, false, null);
            }
        }
    }

    public static void mappingErrorFromTemplateEditor(JavaTextEditor editor) {
        IEditorInput editorInput;
        MultiPageEditorPart multiPageEditorPart = JavaTextEditorHelper.getMultiPageEditorPart(editor);
        if (multiPageEditorPart == null) {
            return;
        }
        JavaTemplateEditor javaTemplateEditor = (JavaTemplateEditor)multiPageEditorPart;
        IEditorPart templateEditorPart = javaTemplateEditor.getTemplateFileEditorPart();
        Pattern pattern = editor.getPattern();
        Map editors = javaTemplateEditor.getEditorMap();
        if (!(templateEditorPart instanceof JavaEditor)) {
            return;
        }
        JavaEditor fEditor = (JavaEditor)templateEditorPart;
        IDocumentProvider p = fEditor.getDocumentProvider();
        if (p == null) {
            IFile templateFile = javaTemplateEditor.getTemplateFile();
            WorkbenchPage templateActivePage = javaTemplateEditor.getTemplateActivePage();
            try {
                if (templateActivePage == null || templateFile == null) {
                    return;
                }
                fEditor = (JavaEditor)IDE.openEditor((IWorkbenchPage)templateActivePage, (IFile)templateFile, (boolean)false);
                templateActivePage.setEditorAreaVisible(false);
            }
            catch (Exception e) {
                Activator.getDefault();
                Activator.log(e);
            }
            p = fEditor.getDocumentProvider();
        }
        if ((editorInput = fEditor.getEditorInput()) == null) {
            return;
        }
        if (p == null) {
            return;
        }
        IAnnotationModel javaAnnotationModel = p.getAnnotationModel((Object)editorInput);
        if (javaAnnotationModel == null) {
            return;
        }
        Map<String, Position> mappings = JavaTextEditorHelper.getMappings(pattern, editors);
        if (mappings == null || mappings.size() == 0) {
            return;
        }
        EList allParameters = pattern.getAllParameters();
        EList allVariables = pattern.getAllVariables();
        javaAnnotationModel = JavaTextEditorHelper.clearDirtyAnnotationForPatternVariAndParam(javaAnnotationModel, allParameters);
        javaAnnotationModel = JavaTextEditorHelper.clearDirtyAnnotationForPatternVariAndParam(javaAnnotationModel, allVariables);
        for (String id : editors.keySet()) {
            TextEditor textEditor = (TextEditor)editors.get(id);
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            if (documentProvider == null) continue;
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)textEditor.getEditorInput());
            Iterator iter = annotationModel.getAnnotationIterator();
            while (iter.hasNext()) {
                Annotation annotation = (Annotation)iter.next();
                annotationModel.removeAnnotation(annotation);
            }
            Iterator annotationIterator = javaAnnotationModel.getAnnotationIterator();
            Position position = mappings.get(id);
            int startOffset = position.offset;
            int endOffset = position.offset + position.length - 1;
            if (annotationModel == null) continue;
            while (annotationIterator.hasNext()) {
                Position posi;
                String text;
                Annotation annotation = (Annotation)annotationIterator.next();
                if (!annotation.getType().equals("org.eclipse.jdt.ui.error") || (text = annotation.getText()) != null && (text.startsWith("The declared package ") || text.startsWith("The public type ")) || (posi = javaAnnotationModel.getPosition(annotation)) == null) continue;
                int offset = posi.offset;
                if (startOffset == 0 && offset == -1) {
                    annotationModel.addAnnotation(annotation, posi);
                }
                if (offset < startOffset || offset > endOffset) continue;
                posi.setOffset(offset - startOffset);
                annotationModel.addAnnotation(annotation, posi);
            }
        }
    }

    private static IAnnotationModel clearDirtyAnnotationForPatternVariAndParam(IAnnotationModel javaAnnotationModel, EList list) {
        if (list == null || list.size() == 0) {
            return javaAnnotationModel;
        }
        new ArrayList();
        Iterator annotationIterator = javaAnnotationModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Annotation annotation;
            Object next = annotationIterator.next();
            if (!(next instanceof Annotation) || (annotation = (Annotation)next) == null || annotation.getText() == null) continue;
            String filter = "";
            for (Object obj : list) {
                if (obj instanceof PatternParameter) {
                    filter = ((PatternParameter)obj).getName();
                } else if (obj instanceof PatternVariable) {
                    filter = ((PatternVariable)obj).getName();
                }
                filter = String.valueOf(filter) + " ";
                if (!annotation.getText().startsWith(filter)) continue;
                javaAnnotationModel.removeAnnotation(annotation);
            }
        }
        return javaAnnotationModel;
    }

    public static void refreshPublicTemplateEditor(JavaTextEditor editor) {
        MultiPageEditorPart multiPageEditorPart = JavaTextEditorHelper.getMultiPageEditorPart(editor);
        if (multiPageEditorPart == null) {
            return;
        }
        IEditorPart templateEditorPart = ((JavaTemplateEditor)multiPageEditorPart).getTemplateFileEditorPart();
        if (templateEditorPart == null) {
            return;
        }
        Pattern pattern = editor.getPattern();
        IEditorInput editorInput = templateEditorPart.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFile templateFile = ((IFileEditorInput)editorInput).getFile();
            JavaTextEditorHelper.refreshPublicTemplateEditor(pattern, templateFile, editor);
        }
    }

    public static InputStream getInputStreamOfEditor(JavaTextEditor editor) {
        ISourceViewer viewer = editor.getViewer();
        if (viewer == null) {
            return null;
        }
        IDocument document = viewer.getDocument();
        return new ByteArrayInputStream(document.get().getBytes());
    }

    public static Map<String, Position> getMappings(Pattern pattern, Map<String, TextEditor> editors) {
        EList methods = pattern.getMethods();
        HashMap<String, Position> mappings = new HashMap<String, Position>();
        int startOffset = 0;
        for (PatternMethod method : methods) {
            String id = method.getID();
            TextEditor textEditor = editors.get(id);
            if (textEditor == null) continue;
            ISourceViewer viewer = ((JavaTextEditor)textEditor).getViewer();
            if (viewer == null || viewer.getDocument() == null) {
                return null;
            }
            int length = viewer.getDocument().getLength();
            mappings.put(id, new Position(startOffset, length));
            startOffset = startOffset + length + 1;
        }
        return mappings;
    }

    public static int getMappingOffset(Pattern pattern, JavaTextEditor editor, int offset) {
        MultiPageEditorPart multiPageEditorPart = JavaTextEditorHelper.getMultiPageEditorPart(editor);
        if (multiPageEditorPart == null) {
            return offset;
        }
        Map editors = ((JavaTemplateEditor)multiPageEditorPart).getEditorMap();
        int mappingOffset = offset;
        int activePage = multiPageEditorPart.getActivePage();
        EList methods = pattern.getMethods();
        int i = 0;
        while (i < activePage) {
            PatternMethod method = (PatternMethod)methods.get(i);
            String id = method.getID();
            JavaTextEditor currentEditor = (JavaTextEditor)((Object)editors.get(id));
            if (currentEditor == null || ((Object)((Object)editor)).equals((Object)currentEditor)) {
                return mappingOffset;
            }
            ISourceViewer viewer = currentEditor.getViewer();
            int length = viewer.getDocument().getLength();
            mappingOffset = mappingOffset + length + 1;
            ++i;
        }
        return mappingOffset;
    }

    public static MultiPageEditorPart getMultiPageEditorPart(TextEditor editor) {
        IWorkbenchPartSite site = editor.getSite();
        if (site instanceof MultiPageEditorSite) {
            return ((MultiPageEditorSite)site).getMultiPageEditor();
        }
        return null;
    }

    public static int getActivePageIndex(ITextEditor editor) {
        IWorkbenchPartSite site = ((JavaTextEditor)editor).getSite();
        MultiPageEditorPart multiPageEditor = ((MultiPageEditorSite)site).getMultiPageEditor();
        return multiPageEditor.getActivePage();
    }

    public static IAnnotationModel getAnnotationModel(JavaEditor fEditor) {
        IAnnotationModel m;
        if (fEditor == null) {
            return null;
        }
        IDocumentProvider p = fEditor.getDocumentProvider();
        if (p == null) {
            p = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
        }
        if ((m = p.getAnnotationModel((Object)fEditor.getEditorInput())) instanceof IProblemRequestorExtension) {
            return m;
        }
        return null;
    }
}

