/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.jet.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.pattern.common.java.AbstractJavaEngine;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.jet.JetPreferences;
import org.eclipse.egf.pattern.jet.Messages;
import org.eclipse.egf.pattern.jet.engine.JetAssemblyContentProvider;
import org.eclipse.egf.pattern.jet.engine.JetAssemblyHelper;
import org.eclipse.egf.pattern.jet.engine.JetNatureHelper;
import org.eclipse.egf.pattern.jet.engine.SkeletonJETCompiler;
import org.eclipse.egf.pattern.utils.FileHelper;
import org.eclipse.egf.pattern.utils.JavaMethodGenerationHelper;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;

public class JetEngine
extends AbstractJavaEngine {
    public JetEngine(Pattern pattern) throws PatternException {
        super(pattern);
    }

    public void translate() throws PatternException {
        Pattern pattern = this.getPattern();
        JetAssemblyHelper helper = new JetAssemblyHelper(this.getPattern(), new JetAssemblyContentProvider(this.getPattern()));
        String templatecontent = helper.visit();
        String templateURI = "Pattern_" + pattern.getName() + " (" + pattern.getID() + ")";
        try {
            SkeletonJETCompiler compiler = new SkeletonJETCompiler(templateURI, new ByteArrayInputStream(templatecontent.getBytes()), JetPreferences.getEncoding());
            compiler.parse();
            if (pattern.getSuperPattern() != null) {
                Pattern parentPattern = pattern.getSuperPattern();
                ((SkeletonJETCompiler.CustomJETSkeleton)compiler.getSkeleton()).setParentClass(JetNatureHelper.getTemplateClassName(parentPattern));
            }
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            compiler.generate(outStream);
            String targetClassName = JetNatureHelper.getTemplateClassName(pattern);
            IPath outputPath = this.computeFilePath(targetClassName);
            IPlatformFcore platformFcore = PatternHelper.getPlatformFcore((PatternElement)this.getPattern());
            if (platformFcore == null) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error4, (Object)pattern.getName(), (Object)pattern.getID()));
            }
            IProject project = platformFcore.getPlatformBundle().getProject();
            if (project == null) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error5, (Object)pattern.getName(), (Object)pattern.getID()));
            }
            FileHelper.setContent((IFile)project.getFile(outputPath), (String)this.getContent(new String(outStream.toByteArray())));
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
    }

    private String getContent(String content) {
        int indexOf;
        StringBuilder builder = new StringBuilder(content.length() + 500);
        int startIndex = content.indexOf("//Start of work");
        int endIndex = content.indexOf("//End of work");
        int insertionIndex = content.lastIndexOf(125);
        if (startIndex == -1 || endIndex == -1 || insertionIndex == -1) {
            return content;
        }
        builder.append(content.substring(0, startIndex));
        Pattern pattern = this.getPattern();
        builder.append("orchestration").append("(ctx);");
        int startMethodIndex = content.indexOf("//Start of methods", endIndex);
        int endMethodIndex = content.indexOf("//End of methods", endIndex);
        if (startMethodIndex != -1 && endMethodIndex != -1) {
            builder.append(content.substring(endIndex + "//End of work".length(), startMethodIndex));
            builder.append(content.substring(endMethodIndex + "//End of methods".length(), insertionIndex));
        } else {
            builder.append(content.substring(endIndex + "//End of work".length(), insertionIndex));
        }
        builder.append("public String ").append("orchestration").append("(PatternContext ctx) throws Exception  {").append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append("InternalPatternContext ictx = (InternalPatternContext)ctx;").append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append("int index = 0, executionIndex = ictx.getExecutionBuffer().length();").append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append(content.substring(startIndex + "//Start of work".length(), endIndex));
        builder.append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append("String loop = ictx.getBuffer().toString();").append(EGFCommonConstants.LINE_SEPARATOR);
        if (!this.getPattern().getAllParameters().isEmpty()) {
            builder.append("if (ictx.useReporter()){").append(EGFCommonConstants.LINE_SEPARATOR);
            builder.append("    ictx.getExecutionBuffer().append(ictx.getBuffer().substring(index));").append(EGFCommonConstants.LINE_SEPARATOR);
            builder.append("    Map<String, Object> parameterValues = new HashMap<String, Object>();").append(EGFCommonConstants.LINE_SEPARATOR);
            for (PatternParameter parameter : pattern.getAllParameters()) {
                String name = parameter.getName();
                builder.append("    parameterValues.put(\"").append(name).append("\", this.").append(name).append(");").append(EGFCommonConstants.LINE_SEPARATOR);
            }
            builder.append("    ictx.getReporter().loopFinished(loop, ictx, parameterValues);").append(EGFCommonConstants.LINE_SEPARATOR);
            builder.append("    ictx.clearBuffer();}").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        builder.append("return loop;").append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append("} ").append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append("").append(EGFCommonConstants.LINE_SEPARATOR);
        int startVariable = content.indexOf("//Start of init");
        int endVariable = content.indexOf("//End of init");
        if (startVariable != -1 && endVariable != -1 && (indexOf = builder.indexOf("//Here is the constructor")) != -1) {
            CharSequence sequence = content.subSequence(startVariable + "//Start of init".length(), endVariable);
            builder.insert(indexOf += "//Here is the constructor".length(), sequence);
            builder.insert(indexOf, "\nStringBuffer stringBuffer = new StringBuffer();\n");
            startVariable = builder.indexOf("//Start of init");
            endVariable = builder.indexOf("//End of init");
            if (startVariable != -1 && endVariable != -1) {
                builder.delete(startVariable, endVariable + "//End of init".length());
            }
        }
        for (PatternVariable var : pattern.getVariables()) {
            builder.append("protected ").append(ParameterTypeHelper.INSTANCE.getTypeLiteral(var.getType())).append(" ").append(var.getName()).append(" = null;").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        for (PatternVariable var : pattern.getParameters()) {
            String type = ParameterTypeHelper.INSTANCE.getTypeLiteral(var.getType());
            builder.append("protected ").append(type).append(" ").append(var.getName()).append(" = null;").append(EGFCommonConstants.LINE_SEPARATOR);
            builder.append("public void ").append(JavaMethodGenerationHelper.getSetterMethod((PatternParameter)var)).append("(").append(type).append(" object) {").append(EGFCommonConstants.LINE_SEPARATOR);
            builder.append("this.").append(var.getName()).append(" = object;").append(EGFCommonConstants.LINE_SEPARATOR);
            builder.append("}").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        if (startMethodIndex != -1 && endMethodIndex != -1) {
            builder.append(content.substring(startMethodIndex + "//Start of methods".length(), endMethodIndex));
        }
        builder.append(content.substring(insertionIndex));
        return builder.toString();
    }

    protected String getPatternClassname() throws PatternException {
        return JetNatureHelper.getTemplateClassName(this.getPattern());
    }
}

