/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors;

import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class PatternEditorInput
implements IEditorInput {
    public static final String PATTERN_ID = "patternId";
    public static final String RESSOURCE_URI = "uri";
    private final PatternPersistableElement persistable = new PatternPersistableElement();
    private final String fragment;
    private final Resource resource;
    private boolean isReadOnly = false;

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public PatternEditorInput(Resource resource, String fragment) {
        if (fragment == null || resource == null) {
            throw new IllegalArgumentException();
        }
        this.resource = resource;
        this.fragment = fragment;
    }

    public boolean exists() {
        return true;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public Pattern getPattern() {
        return (Pattern)this.resource.getEObject(this.fragment);
    }

    public Resource getResource() {
        return this.resource;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.getPattern() == null) {
            return "";
        }
        return this.getPattern().getName();
    }

    public IPersistableElement getPersistable() {
        return this.persistable;
    }

    public String getToolTipText() {
        return this.resource.getURI().toPlatformString(false);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    private class PatternPersistableElement
    implements IPersistableElement {
        private PatternPersistableElement() {
        }

        public void saveState(IMemento memento) {
            if (PatternEditorInput.this.getPattern() != null) {
                memento.putString(PatternEditorInput.PATTERN_ID, PatternEditorInput.this.getPattern().getID());
                memento.putString(PatternEditorInput.RESSOURCE_URI, PatternEditorInput.this.resource.getURI().toString());
            }
        }

        public String getFactoryId() {
            return "org.eclipse.egf.pattern.ui.pattern.factory.id";
        }
    }
}

