/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.JETTextPreviewViewer;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class JETEditor
extends FormEditor
implements ITextEditorExtension,
IMenuListener,
IGotoMarker {
    public static final String ID = "org.eclipse.jet.internal.editor";
    public static final String copyright = "(c) 2006 Joel Cheuoua & Contributors";
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected ISelectionChangedListener selectionChangedListener;
    protected JETTextEditor jetTextEditor = new JETTextEditor();

    public JETTextEditor getJetTextEditor() {
        return this.jetTextEditor;
    }

    public void addPages() {
        try {
            int pageIndex = this.addPage((IEditorPart)this.jetTextEditor, this.getEditorInput());
            this.setPageText(pageIndex, "Edition");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        JETTextPreviewViewer viewer = new JETTextPreviewViewer(this.getContainer());
        viewer.setInput(this.getEditorInput());
        int pageIndex = this.addPage(viewer.getControl());
        this.setPageText(pageIndex, "Preview");
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.jetTextEditor.getAdapter(key);
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IPropertySheetPage getPropertySheetPage() {
        return this.propertySheetPage;
    }

    public boolean isDirty() {
        return this.jetTextEditor != null && this.jetTextEditor.isDirty();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        if (this.jetTextEditor != null) {
            this.jetTextEditor.doSave(progressMonitor);
        }
    }

    public boolean isSaveAsAllowed() {
        if (this.jetTextEditor != null) {
            return this.jetTextEditor.isSaveAsAllowed();
        }
        return true;
    }

    public void doSaveAs() {
        if (this.jetTextEditor != null) {
            this.jetTextEditor.doSaveAs();
        }
    }

    public void gotoMarker(IMarker marker) {
        IGotoMarker gotoMarker;
        if (this.jetTextEditor != null && (gotoMarker = (IGotoMarker)this.jetTextEditor.getAdapter(IGotoMarker.class)) != null) {
            gotoMarker.gotoMarker(marker);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        this.jetTextEditor.init(site, editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)new MultiPageSelectionProvider((MultiPageEditorPart)this));
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public void dispose() {
        if (this.jetTextEditor != null) {
            this.jetTextEditor.dispose();
        }
        super.dispose();
    }

    public void setStatusField(IStatusField field, String category) {
        if (this.jetTextEditor != null) {
            this.jetTextEditor.setStatusField(field, category);
        }
    }

    public boolean isEditorInputReadOnly() {
        if (this.jetTextEditor != null) {
            this.jetTextEditor.isEditorInputReadOnly();
        }
        return false;
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
        if (this.jetTextEditor != null) {
            this.jetTextEditor.addRulerContextMenuListener(listener);
        }
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
        if (this.jetTextEditor != null) {
            this.jetTextEditor.removeRulerContextMenuListener(listener);
        }
    }
}

