/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SpreadMethod implements Enumerator
{
    PAD(0, "pad", "pad"),
    REFLECT(1, "reflect", "reflect"),
    REPEAT(2, "repeat", "repeat");

    public static final int PAD_VALUE = 0;
    public static final int REFLECT_VALUE = 1;
    public static final int REPEAT_VALUE = 2;
    private static final SpreadMethod[] VALUES_ARRAY;
    public static final List<SpreadMethod> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SpreadMethod[]{PAD, REFLECT, REPEAT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SpreadMethod get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SpreadMethod result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SpreadMethod getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SpreadMethod result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SpreadMethod get(int value) {
        switch (value) {
            case 0: {
                return PAD;
            }
            case 1: {
                return REFLECT;
            }
            case 2: {
                return REPEAT;
            }
        }
        return null;
    }

    private SpreadMethod(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

