/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.jni.win32;

import org.eclipse.fx.drift.internal.jni.win32.ErrorCode;
import org.eclipse.fx.drift.internal.jni.win32.HRESULT;

public class WindowsError
extends Exception {
    public final int errorCode;
    public final ErrorCode error;
    public final long hresultCode;
    public final HRESULT hresult;
    private static boolean checkErrors = true;

    private static String createMessage(int errorCode) {
        return "0x" + Integer.toHexString(errorCode) + ": " + (Object)((Object)ErrorCode.fromValue(errorCode));
    }

    private static String createHResultMessage(long hresult) {
        return "HRESULT 0x" + Long.toHexString(hresult) + ": " + (Object)((Object)HRESULT.fromValue(hresult));
    }

    public WindowsError(int errorCode) {
        super(WindowsError.createMessage(errorCode));
        this.errorCode = errorCode;
        this.error = ErrorCode.fromValue(errorCode);
        this.hresultCode = 0L;
        this.hresult = null;
    }

    public WindowsError(long hresult) {
        super(WindowsError.createHResultMessage(hresult));
        this.hresultCode = hresult;
        this.hresult = HRESULT.fromValue(hresult);
        this.errorCode = 0;
        this.error = null;
    }

    public static native int getLastError();

    public static void checkLastError() throws WindowsError {
        int error;
        if (checkErrors && (error = WindowsError.getLastError()) != 0) {
            throw WindowsError.fromErrorCode(error);
        }
    }

    public static void checkHResult(long hresult) throws WindowsError {
        if (checkErrors && (hresult &= 0xFFFFFFFFL) != 0L) {
            throw WindowsError.fromHResult(hresult);
        }
    }

    private static WindowsError fromHResult(long hresult) {
        return new WindowsError(hresult);
    }

    private static WindowsError fromErrorCode(int errorCode) {
        return new WindowsError(errorCode);
    }
}

