/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.prism;

import com.sun.prism.Texture;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.eclipse.fx.drift.internal.DriftFX;
import org.eclipse.fx.drift.internal.DriftLogger;
import org.eclipse.fx.drift.internal.Versioning;
import org.eclipse.fx.drift.internal.jni.win32.Win32;
import org.eclipse.fx.drift.internal.prism.PrismD3D;
import org.eclipse.fx.drift.internal.prism.PrismES2;

public class Prism {
    private static final DriftLogger LOGGER = DriftFX.createLogger(Prism.class);
    private static Class<?> cGraphicsPipeline;
    private static Method mGraphicsPipelineGetDefaultResourceFactory;
    private static Class<?> cResourceFactory;
    private static Object iDefaultResourceFactory;
    private static boolean isD3D;
    private static boolean isSW;
    private static boolean isES2;
    private static Object iD3DContext;
    private static long contextHandleD3D;
    private static Win32.IDirect3DDevice9Ex d3dDevice;
    private static Object iES2Context;
    private static Object iGLContext;
    private static long contextHandleES2;

    private Prism() {
    }

    private static Optional<Class<?>> getClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static void initialize() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException {
        LOGGER.info(() -> "DriftFX " + Versioning.getVersion() + " (git sha: " + Versioning.getSha() + ") initializing");
        cGraphicsPipeline = Class.forName("com.sun.prism.GraphicsPipeline");
        mGraphicsPipelineGetDefaultResourceFactory = cGraphicsPipeline.getMethod("getDefaultResourceFactory", new Class[0]);
        cResourceFactory = Class.forName("com.sun.prism.ResourceFactory");
        iDefaultResourceFactory = mGraphicsPipelineGetDefaultResourceFactory.invoke(null, new Object[0]);
        String name = iDefaultResourceFactory.getClass().getName();
        isD3D = "com.sun.prism.d3d.D3DResourceFactory".equals(name);
        isES2 = "com.sun.prism.es2.ES2ResourceFactory".equals(name);
        isSW = "com.sun.prism.sw.SWResourceFactory".equals(name);
        if (isD3D) {
            PrismD3D.initialize();
            iD3DContext = PrismD3D.getD3DContext(iDefaultResourceFactory);
            contextHandleD3D = PrismD3D.getContextHandle(iD3DContext);
            LOGGER.debug(() -> " * D3D Context handle = " + contextHandleD3D);
            d3dDevice = org.eclipse.fx.drift.internal.jni.win32.Prism.getPrismIDirect3DDevice9Ex(contextHandleD3D);
            LOGGER.debug(() -> " * D3D Context direct3D device = " + d3dDevice);
        } else if (isES2) {
            PrismES2.initialize();
            iES2Context = PrismES2.getES2Context(iDefaultResourceFactory);
            iGLContext = PrismES2.getGLContext(iES2Context);
            contextHandleES2 = PrismES2.getNativeHandle(iGLContext);
        } else {
            if (isSW) {
                throw new UnsupportedOperationException("SW Support not yet implemented!");
            }
            throw new UnsupportedOperationException("Unknown JavaFX pipeline!");
        }
    }

    public static boolean isD3D() {
        return isD3D;
    }

    public static boolean isSW() {
        return isSW;
    }

    public static boolean isES2() {
        return isES2;
    }

    public static long getES2ContextHandle() {
        return contextHandleES2;
    }

    public static long getTextureHandle(Texture texture) {
        if (Prism.isD3D()) {
            try {
                Class<?> d3dTexture = Class.forName("com.sun.prism.d3d.D3DTexture");
                Method mD3DTextureGetNativeSourceHandle = d3dTexture.getMethod("getNativeSourceHandle", new Class[0]);
                mD3DTextureGetNativeSourceHandle.setAccessible(true);
                return (Long)mD3DTextureGetNativeSourceHandle.invoke((Object)texture, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (Prism.isES2()) {
            return PrismES2.getTextureName(texture);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public static Win32.IDirect3DDevice9Ex getD3DDevice() {
        return d3dDevice;
    }

    static {
        DriftFX.require();
    }
}

