/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.signature;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import servlet.tck.signature.PackageList;
import servlet.tck.signature.SignatureTestDriver;

public class SigTestDriver
extends SignatureTestDriver {
    private static final System.Logger logger = System.getLogger(SigTestDriver.class.getName());
    private static final String CLASSPATH_FLAG = "-Classpath";
    private static final String FILENAME_FLAG = "-FileName";
    private static final String PACKAGE_FLAG = "-Package";
    private static final String API_VERSION_FLAG = "-ApiVersion";
    private static final String EXCLUDE_FLAG = "-Exclude";
    private static final String STATIC_FLAG = "-Static";
    private static final String CHECKVALUE_FLAG = "-CheckValue";
    private static final String SMODE_FLAG = "-mode";
    private static final String EXCLUDE_JDK_CLASS_FLAG = "-IgnoreJDKClass";

    @Override
    protected String[] createTestArguments(String packageListFile, String mapFile, String signatureRepositoryDir, String packageOrClassUnderTest, String classpath, boolean bStaticMode) throws Exception {
        SignatureTestDriver.SignatureFileInfo info = this.getSigFileInfo(packageOrClassUnderTest, mapFile, signatureRepositoryDir);
        PackageList packageList = new PackageList(packageListFile);
        String[] subPackages = packageList.getSubPackages(packageOrClassUnderTest);
        ArrayList<String> command = new ArrayList<String>();
        if (bStaticMode) {
            logger.log(System.Logger.Level.TRACE, "Setting static mode flag to allow constant checking.");
            command.add(STATIC_FLAG);
            command.add(CHECKVALUE_FLAG);
            command.add(SMODE_FLAG);
            command.add("src");
        } else {
            logger.log(System.Logger.Level.TRACE, "Not Setting static mode flag to allow constant checking.");
        }
        command.add("-Verbose");
        command.add(FILENAME_FLAG);
        command.add(info.getFile());
        command.add(CLASSPATH_FLAG);
        command.add(classpath);
        command.add(PACKAGE_FLAG);
        command.add(packageOrClassUnderTest);
        for (int i = 0; i < subPackages.length; ++i) {
            command.add(EXCLUDE_FLAG);
            command.add(subPackages[i]);
        }
        command.add(EXCLUDE_JDK_CLASS_FLAG);
        command.add(API_VERSION_FLAG);
        command.add(info.getVersion());
        return command.toArray(new String[0]);
    }

    @Override
    protected boolean runSignatureTest(String packageOrClassName, String[] testArguments) throws Exception {
        Class<?> sigTestClass = Class.forName("com.sun.tdk.signaturetest.SignatureTest");
        Object sigTestInstance = sigTestClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        logger.log(System.Logger.Level.TRACE, "\nCalling:  com.sun.tdk.signaturetest.SignatureTest() with following args:");
        for (int ii = 0; ii < testArguments.length; ++ii) {
            logger.log(System.Logger.Level.TRACE, "   testArguments[" + ii + "] = " + testArguments[ii]);
        }
        Method runMethod = sigTestClass.getDeclaredMethod("run", String[].class, PrintWriter.class, PrintWriter.class);
        runMethod.invoke(sigTestInstance, testArguments, new PrintWriter(output, true), null);
        String rawMessages = output.toString();
        logger.log(System.Logger.Level.INFO, "********** Status Report '" + packageOrClassName + "' **********\n");
        logger.log(System.Logger.Level.INFO, rawMessages);
        return sigTestInstance.toString().substring(7).startsWith("Passed.");
    }
}

