/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.httpupgradehandler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import servlet.tck.api.jakarta_servlet_http.httpupgradehandler.TCKHttpUpgradeHandler;
import servlet.tck.api.jakarta_servlet_http.httpupgradehandler.TCKReadListener;
import servlet.tck.api.jakarta_servlet_http.httpupgradehandler.TestServlet;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.servlets.CommonServlets;
import servlet.tck.common.util.ServletTestUtil;

public class HttpUpgradeHandlerTests
extends AbstractTckTest {
    private static final String CRLF = "\r\n";

    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("TestServlet");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_jsh_upgradehandler_web.war")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addClasses(new Class[]{TCKHttpUpgradeHandler.class, TCKReadListener.class, TestServlet.class});
    }

    @Test
    public void upgradeTest() throws Exception {
        Boolean passed1 = false;
        Boolean passed2 = false;
        Boolean passed3 = false;
        String EXPECTED_RESPONSE1 = "TCKHttpUpgradeHandler.init";
        String EXPECTED_RESPONSE2 = "onDataAvailable|Hello";
        String EXPECTED_RESPONSE3 = "onDataAvailable|World";
        String requestUrl = this.getContextRoot() + "/" + this.getServletName() + " HTTP/1.1";
        URL url = this.getURL("http", this._hostname, this._port, requestUrl.substring(1));
        try (Socket s = new Socket(this._hostname, this._port);
             OutputStream output = s.getOutputStream();
             InputStream input = s.getInputStream();){
            StringBuilder reqStr = new StringBuilder("POST " + url.toExternalForm().replace("http://", "").replace(this._hostname, "").replace(":" + this._port, "") + CRLF);
            reqStr.append("User-Agent: Java/1.6.0_33\r\n");
            reqStr.append("Host: ").append(this._hostname).append(":").append(this._port).append(CRLF);
            reqStr.append("Accept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2\r\n");
            reqStr.append("Upgrade: YES\r\n");
            reqStr.append("Connection: Upgrade\r\n");
            reqStr.append("Content-type: application/x-www-form-urlencoded\r\n");
            reqStr.append(CRLF);
            this.logger.debug("REQUEST========= {}", (Object)reqStr);
            output.write(reqStr.toString().getBytes());
            this.logger.debug("Writing first chunk");
            HttpUpgradeHandlerTests.writeChunk(output, "Hello");
            this.logger.debug("Writing second chunk");
            HttpUpgradeHandlerTests.writeChunk(output, "World");
            this.logger.debug("Consuming the response from the server");
            int len = -1;
            byte[] b = new byte[1024];
            boolean receivedFirstMessage = false;
            boolean receivedSecondMessage = false;
            boolean receivedThirdMessage = false;
            StringBuilder sb = new StringBuilder();
            while ((len = input.read(b)) != -1) {
                String line = new String(b, 0, len);
                sb.append(line);
                this.logger.debug("==============Read from server: {} {} {}", new Object[]{CRLF, sb, CRLF});
                passed1 = ServletTestUtil.compareString(EXPECTED_RESPONSE1, sb.toString());
                if (passed1.booleanValue()) {
                    this.logger.debug("==============Received first expected response!");
                    receivedFirstMessage = true;
                }
                if ((passed2 = Boolean.valueOf(ServletTestUtil.compareString(EXPECTED_RESPONSE2, sb.toString()))).booleanValue()) {
                    this.logger.debug("==============Received second expected response!");
                    receivedSecondMessage = true;
                }
                if ((passed3 = Boolean.valueOf(ServletTestUtil.compareString(EXPECTED_RESPONSE3, sb.toString()))).booleanValue()) {
                    this.logger.debug("==============Received third expected response!");
                    receivedThirdMessage = true;
                }
                this.logger.debug("receivedFirstMessage : {}", (Object)receivedFirstMessage);
                this.logger.debug("receivedSecondMessage : {}", (Object)receivedSecondMessage);
                this.logger.debug("receivedThirdMessage : {}", (Object)receivedThirdMessage);
                if (!receivedFirstMessage || !receivedSecondMessage || !receivedThirdMessage) continue;
                break;
            }
        }
        catch (Exception ex2) {
            this.logger.error("exception caught: " + ex2.getMessage(), (Throwable)ex2);
        }
        if (!(passed1.booleanValue() && passed2.booleanValue() && passed3.booleanValue())) {
            throw new Exception("Test Failed. ");
        }
    }

    private static void writeChunk(OutputStream out, String data) throws IOException {
        if (data != null) {
            out.write(data.getBytes());
        }
        out.flush();
    }
}

