/*
 * Copyright (c) 2007, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package ee.jakarta.tck.pages.spec.el.jsp;

import java.io.IOException;

import ee.jakarta.tck.pages.common.util.JspTestUtil;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.SimpleTagSupport;

public class ELDeferredValueValueTag extends SimpleTagSupport {

  private final static String LITVAL = "foo";

  private final static String POUNDVAL = "bar";

  private ValueExpression litExpr;

  private ValueExpression poundExpr;

  public void setLitExpr(ValueExpression litExpr) {
    this.litExpr = litExpr;
  }

  public void setPoundExpr(ValueExpression poundExpr) {
    this.poundExpr = poundExpr;
  }

  public void doTag() throws JspException, IOException {
    ELContext elContext = getJspContext().getELContext();
    JspWriter out = getJspContext().getOut();

    try {
      String litVal = (String) litExpr.getValue(elContext);
      if (!litVal.equals(LITVAL)) {
        out.println("Test FAILED. Wrong value for literal expression.");
        out.println("Expected value: " + LITVAL);
        out.println("Retrieved value: " + litVal);
        return;
      }
      String poundVal = (String) poundExpr.getValue(elContext);
      if (!poundVal.equals(POUNDVAL)) {
        out.println("Test FAILED. Wrong value for pound expression.");
        out.println("Expected value: " + POUNDVAL);
        out.println("Retrieved value: " + poundVal);
        return;
      }
      out.println("Test PASSED.");
    } catch (Throwable t) {
      JspTestUtil.handleThrowable(t, out, "ELDeferredValueValueTag");
    }
  }
}
