/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.tagfiles.implicitobjects;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    private static final String CONTEXT_ROOT = "/jsp_tagfiles_implicitobjects_web";

    public URLClientIT() throws Exception {
        this.setContextRoot(CONTEXT_ROOT);
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_tagfiles_implicitobjects_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_tagfiles_implicitobjects_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/checkSession.tag", "tags/checkSession.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/checkRequest.tag", "tags/checkRequest.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/checkResponse.tag", "tags/checkResponse.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/checkOut.tag", "tags/checkOut.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/checkJspContext.tag", "tags/checkJspContext.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/checkConfig.tag", "tags/checkConfig.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/checkApplication.tag", "tags/checkApplication.tag");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkSession.jsp")), "checkSession.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkResponse.jsp")), "checkResponse.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkRequest.jsp")), "checkRequest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkOut.jsp")), "checkOut.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkJspContext.jsp")), "checkJspContext.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkConfig.jsp")), "checkConfig.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkApplication.jsp")), "checkApplication.jsp");
        return archive;
    }

    @Test
    public void checkSessionTest() throws Exception {
        String testName = "checkSession";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfiles_implicitobjects_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "true|checkSession");
        this.invoke();
    }

    @Test
    public void checkConfigTest() throws Exception {
        String testName = "checkConfig";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfiles_implicitobjects_web/checkConfig HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "true|param1 is:|hobbit|param2 is:|gollum");
        this.invoke();
    }

    @Test
    public void checkOutTest() throws Exception {
        String testName = "checkOut";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfiles_implicitobjects_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "true");
        this.invoke();
    }

    @Test
    public void checkJspContextTest() throws Exception {
        String testName = "checkJspContext";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfiles_implicitobjects_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "true|true");
        this.invoke();
    }

    @Test
    public void checkRequestTest() throws Exception {
        String testName = "checkRequest";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfiles_implicitobjects_web/" + testName + ".jsp?Years=2 HTTP/1.0");
        TEST_PROPS.setProperty("search_string", "true|HTTP|1.0|2");
        this.invoke();
    }

    @Test
    public void checkResponseTest() throws Exception {
        String testName = "checkResponse";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfiles_implicitobjects_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "true");
        TEST_PROPS.setProperty("expected_headers", "TestHeader:Method call OK");
        this.invoke();
    }

    @Test
    public void checkApplicationTest() throws Exception {
        String testName = "checkApplication";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfiles_implicitobjects_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "true|param1|bilbo");
        this.invoke();
    }
}

