/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.configuration.general;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.spec.configuration.general.AServlet;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    private static final String CONTEXT_ROOT = "/jsp_config_general_web";

    public URLClientIT() throws Exception {
        this.setContextRoot(CONTEXT_ROOT);
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_config_general_web.war");
        archive.addClass(AServlet.class);
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_config_general_web.xml"));
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/prelude3.jsp")), "prelude3.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/prelude2.jsp")), "prelude2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/prelude1.jsp")), "prelude1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/coda3.jsp")), "coda3.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/coda2.jsp")), "coda2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/coda1.jsp")), "coda1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/mostSpecific/page/willSee.jsp")), "mostSpecific/page/willSee.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/identical/willSee.jsp")), "identical/willSee.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/specific/svr/willNotSee.jsp")), "specific/svr/willNotSee.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/specific/svr/page/willSee.jsp")), "specific/svr/page/willSee.jsp");
        return archive;
    }

    @Test
    public void moreSpecificMappingTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_general_web/specific/svr/willNotSee.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "In mapped servlet");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_config_general_web/specific/svr/page/willSee.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "In coda1|In coda1");
        TEST_PROPS.setProperty("unexpected_response_match", "In mapped servlet");
        this.invoke();
    }

    @Test
    public void identicalMappingTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_general_web/identical/willSee.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "In coda1");
        TEST_PROPS.setProperty("unexpected_response_match", "In mapped servlet");
        this.invoke();
    }

    @Test
    public void mostSpecificMappingTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_general_web/mostSpecific/page/willSee.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "In prelude1|In prelude2|In prelude3|el is enabled|In coda1|In coda2|In coda3");
        TEST_PROPS.setProperty("unexpected_response_match", "In mapped servlet");
        this.invoke();
    }
}

