/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.jspidconsumer;

import ee.jakarta.tck.pages.common.util.JspTestUtil;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.JspIdConsumer;
import jakarta.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class SetJspIdTag
extends SimpleTagSupport
implements JspIdConsumer {
    private String jspId;
    private JspWriter out;

    public void setJspId(String id) {
        this.jspId = id;
    }

    public void doTag() throws JspException, IOException {
        this.out = this.getJspContext().getOut();
        try {
            if (this.jspId == null) {
                this.out.println("No ID assigned. Test FAILED");
                return;
            }
            this.out.println("JspId is " + this.jspId);
            if (this.isConformant()) {
                this.out.println("Test PASSED");
            }
        }
        catch (Throwable t) {
            JspTestUtil.handleThrowable(t, this.out, "SetJspIdTag");
        }
    }

    private boolean isConformant() throws IOException {
        char firstChar = this.jspId.charAt(0);
        if (!Character.isLetter(firstChar) && firstChar != '_') {
            this.out.println("First character of ID is not letter or underscore");
            return false;
        }
        for (int i = 1; i < this.jspId.length(); ++i) {
            char ch = this.jspId.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '-' || ch == '_') continue;
            this.out.print("character " + i + " is neither letter, ");
            this.out.println("digit, dash, or underscore");
            return false;
        }
        return true;
    }
}

