/*
 * Copyright (c) 2009, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.jpa.core.derivedid.ex6b;

import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import java.io.Serializable;

/**
 *
 * @author Raja Perumal
 */
@Entity
public class DID6bPerson implements Serializable {

  @EmbeddedId
  DID6bPersonId id;

  private String ssn;

  public DID6bPerson(DID6bPersonId pId, String ssn) {
    this.id = pId;
    this.ssn = ssn;
  }

  public DID6bPerson() {
  }

  public String getSsn() {
    return ssn;
  }

  public void setSsn(String ssn) {
    this.ssn = ssn;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    final DID6bPerson other = (DID6bPerson) obj;
    if (this.id != other.id && (this.id == null || !this.id.equals(other.id))) {
      return false;
    }
    if ((this.ssn == null) ? (other.ssn != null)
        : !this.ssn.equals(other.ssn)) {
      return false;
    }
    return true;
  }

  @Override
  public int hashCode() {
    int hash = 7;
    hash = 41 * hash + (this.id != null ? this.id.hashCode() : 0);
    hash = 41 * hash + (this.ssn != null ? this.ssn.hashCode() : 0);
    return hash;
  }

  @Override
  public String toString() {
    return "derivedssn6b.DID6bPerson[ssn=" + ssn + "]";
  }
}
