/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.loaders;

import com.sun.tdk.signaturetest.core.ModuleDescriptionLoader;
import com.sun.tdk.signaturetest.model.ModuleDescription;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ResolvedModule;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ModuleLoader
implements ModuleDescriptionLoader {
    @Override
    public Set<ModuleDescription> loadBootModules() {
        HashSet<ModuleDescription> result = new HashSet<ModuleDescription>();
        ModuleLayer bootL = ModuleLayer.boot();
        Configuration c = bootL.configuration();
        if (c != null) {
            Set<ResolvedModule> rms = c.modules();
            for (ResolvedModule rm : rms) {
                ModuleDescriptor md = rm.reference().descriptor();
                ModuleDescription rmd = new ModuleDescription();
                rmd.setName(md.name());
                Optional<ModuleDescriptor.Version> vo = md.version();
                if (vo.isPresent()) {
                    rmd.setVersion(vo.get().toString());
                }
                rmd.setPackages(new LinkedHashSet<String>(md.packages()));
                Set<ModuleDescriptor.Exports> exports = md.exports();
                LinkedHashSet<ModuleDescription.Exports> rexports = new LinkedHashSet<ModuleDescription.Exports>();
                for (ModuleDescriptor.Exports me : exports) {
                    ModuleDescription.Exports exp = new ModuleDescription.Exports();
                    exp.source = me.source();
                    exp.targets = new HashSet<String>(me.targets());
                    rexports.add(exp);
                }
                rmd.setExports(rexports);
                Set<ModuleDescriptor.Requires> reqs = md.requires();
                LinkedHashSet<ModuleDescription.Requires> rereqs = new LinkedHashSet<ModuleDescription.Requires>();
                for (ModuleDescriptor.Requires r : reqs) {
                    ModuleDescription.Requires req = new ModuleDescription.Requires();
                    req.name = r.name();
                    if (!r.modifiers().isEmpty()) {
                        LinkedHashSet<ModuleDescription.Requires.Modifier> modifs = new LinkedHashSet<ModuleDescription.Requires.Modifier>();
                        for (ModuleDescriptor.Requires.Modifier m : r.modifiers()) {
                            switch (m) {
                                case STATIC: {
                                    modifs.add(ModuleDescription.Requires.Modifier.STATIC);
                                    break;
                                }
                                case MANDATED: {
                                    modifs.add(ModuleDescription.Requires.Modifier.MANDATED);
                                    break;
                                }
                                case SYNTHETIC: {
                                    modifs.add(ModuleDescription.Requires.Modifier.SYNTHETIC);
                                    break;
                                }
                                case TRANSITIVE: {
                                    modifs.add(ModuleDescription.Requires.Modifier.TRANSITIVE);
                                }
                            }
                        }
                        req.modifiers = modifs;
                    }
                    rereqs.add(req);
                }
                rmd.setRequires(rereqs);
                Set<ModuleDescriptor.Provides> prvs = md.provides();
                LinkedHashMap<String, ModuleDescription.Provides> reprovides = new LinkedHashMap<String, ModuleDescription.Provides>();
                for (ModuleDescriptor.Provides me : prvs) {
                    ModuleDescription.Provides pr = new ModuleDescription.Provides();
                    pr.service = me.service();
                    pr.providers = new LinkedHashSet<String>(me.providers());
                    reprovides.put(pr.service, pr);
                }
                rmd.setProvides(reprovides);
                LinkedHashSet<String> us = new LinkedHashSet<String>(md.uses());
                rmd.setUses(us);
                result.add(rmd);
            }
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public List<String> getExportedPackages(List<String> modules) {
        return this.loadBootModules().stream().filter(md -> modules.contains(md.getName())).flatMap(md -> md.getExports().stream()).filter(ex -> ex.isPublic()).map(ex -> ex.source).collect(Collectors.toList());
    }
}

