/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.config;

import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.RegistrationListener;

public class TSRegistrationListener
implements RegistrationListener {
    String profileLayer;
    String appContext;
    boolean notified = false;
    AuthConfigFactory acf = null;

    public TSRegistrationListener() {
        this.profileLayer = null;
        this.appContext = null;
        this.acf = AuthConfigFactory.getFactory();
    }

    public TSRegistrationListener(String profileLayer, String appContext) {
        this.profileLayer = profileLayer;
        this.appContext = appContext;
        this.acf = AuthConfigFactory.getFactory();
    }

    public String getProfileLayer() {
        return this.profileLayer;
    }

    public void setProfileLayer(String val) {
        this.profileLayer = val;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public void setAppContext(String val) {
        this.appContext = val;
    }

    public void resetNotifyFlag() {
        this.notified = false;
    }

    public boolean notified() {
        return this.notified;
    }

    public boolean check(String layer, String context) {
        boolean match = false;
        boolean rval = true;
        if ((layer == null || this.profileLayer != null && this.profileLayer.equals(layer)) && (context == null || this.appContext != null && this.appContext.equals(context))) {
            match = true;
        }
        String msg = "TSRegistrationListener:  layer=" + this.profileLayer + ",  appcontext=";
        msg = msg + this.appContext + " ExpectedVal=" + this.notified() + "  actualVal=" + match + "for layer=" + layer + " context=" + context;
        if (match && this.notified()) {
            rval = true;
        } else if (match && !this.notified()) {
            rval = false;
            this.debug("in check():  " + msg);
        }
        return rval;
    }

    public void notify(String layer, String context) {
        boolean bContextsMatch;
        this.notified = true;
        boolean bLayersMatch = this.profileLayer == layer || this.profileLayer.equals(layer);
        boolean bl = bContextsMatch = this.appContext == context || this.appContext.equals(context);
        if (bLayersMatch && bContextsMatch) {
            this.debug("successful notification for layer=" + layer + " context=" + context);
        } else {
            String msg = "ERROR - listener notified at wrong profileLayer: " + layer + " or context: " + context;
            this.debug(msg);
        }
    }

    private void debug(String out) {
        System.out.println(out);
    }
}

