/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.impl;

import com.sun.jdo.api.persistence.support.JDODataStoreException;
import com.sun.jdo.api.persistence.support.JDODuplicateObjectIdException;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.api.persistence.support.JDOHelper;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.api.persistence.support.Query;
import com.sun.jdo.spi.persistence.support.sqlstore.ExtentCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperPersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceConfig;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceStore;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.RuntimeVersion;
import com.sun.jdo.spi.persistence.support.sqlstore.SCOCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.ValueFetcher;
import com.sun.jdo.spi.persistence.support.sqlstore.VersionConsistencyCache;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerWrapper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.TransactionImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.query.QueryImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sco.HashSet;
import com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlDate;
import com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlTime;
import com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlTimestamp;
import com.sun.jdo.spi.persistence.utility.NullSemaphore;
import com.sun.jdo.spi.persistence.utility.Semaphore;
import com.sun.jdo.spi.persistence.utility.SemaphoreImpl;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.transaction.Transaction;
import org.glassfish.persistence.common.I18NHelper;

public class PersistenceManagerImpl
implements PersistenceManager {
    private boolean _isClosed = true;
    private PersistenceManagerWrapper current = null;
    private Transaction _jta = null;
    private PersistenceStore _store = null;
    private TransactionImpl _transaction = null;
    private PersistenceManagerFactory persistenceManagerFactory = null;
    private List _txCache;
    private Set _flushedCache;
    private Map _weakCache;
    private boolean cleanupVersionConsistencyCache = false;
    private static final int _txCacheInitialCapacity = Integer.getInteger("com.sun.jdo.api.persistence.support.PersistenceManager.dirtyCache.initialCapacity", 20);
    private static final int _flushedCacheInitialCapacity = Integer.getInteger("com.sun.jdo.api.persistence.support.PersistenceManager.transactionalCache.initialCapacity", 20);
    private static final float _flushedCacheLoadFactor;
    private static final int _weakCacheInitialCapacity;
    private static final float _weakCacheLoadFactor;
    private Collection queries = new ArrayList();
    private boolean _ignoreCache = true;
    private boolean _optimistic = true;
    private boolean _supersedeDeletedInstance = true;
    private boolean _requireCopyObjectId = true;
    private boolean _requireTrackedSCO = true;
    private boolean _nontransactionalRead = true;
    private boolean _activeTransaction = false;
    private Object _userObject = null;
    private boolean _insideCommit = false;
    private boolean _insideFlush = false;
    private static final String oidName_OID = "OID";
    private static final String oidName_KEY = "KEY";
    private Properties _properties = null;
    private final Semaphore _cacheLock;
    private final Semaphore _fieldUpdateLock;
    private Object _readWriteLock = new Object();
    private long _readWriteCount = 0L;
    private long _waiterCount = 0L;
    private Thread _exclusiveLockHolder = null;
    private final boolean _multithreaded;
    private static Logger logger;
    private static final ResourceBundle messages;

    PersistenceManagerImpl(PersistenceManagerFactory pmf, Transaction t, String username, char[] password) {
        this.persistenceManagerFactory = pmf;
        if (logger.isLoggable(300)) {
            Object[] items = new Object[]{new Integer(_txCacheInitialCapacity), new Integer(_flushedCacheInitialCapacity), new Float(_flushedCacheLoadFactor), new Integer(_weakCacheInitialCapacity), new Float(_weakCacheLoadFactor)};
            logger.finest("sqlstore.persistencemgr.cacheproperties", items);
        }
        this._txCache = new ArrayList(_txCacheInitialCapacity);
        this._flushedCache = new LinkedHashSet(_flushedCacheInitialCapacity, _flushedCacheLoadFactor);
        this._weakCache = new HashMap(_weakCacheInitialCapacity, _weakCacheLoadFactor);
        this._transaction = new TransactionImpl(this, username, password, 0);
        this._ignoreCache = pmf.getIgnoreCache();
        this._optimistic = pmf.getOptimistic();
        this._nontransactionalRead = pmf.getNontransactionalRead();
        this._supersedeDeletedInstance = pmf.getSupersedeDeletedInstance();
        this._requireCopyObjectId = pmf.getRequireCopyObjectId();
        this._requireTrackedSCO = pmf.getRequireTrackedSCO();
        this._jta = t;
        this._isClosed = false;
        boolean bl = this._multithreaded = !EJBHelper.isManaged();
        if (this._multithreaded) {
            this._cacheLock = new SemaphoreImpl("PersistenceManagerImpl.cacheLock");
            this._fieldUpdateLock = new SemaphoreImpl("PersistenceManagerImpl.fieldUpdateLock");
        } else {
            this._cacheLock = this._jta == null ? new SemaphoreImpl("PersistenceManagerImpl.cacheLock") : new NullSemaphore("PersistenceManagerImpl.cacheLock");
            this._fieldUpdateLock = new NullSemaphore("PersistenceManagerImpl.fieldUpdateLock");
        }
    }

    protected void setStore(PersistenceStore store) {
        this._store = store;
    }

    protected PersistenceStore getStore() {
        return this._store;
    }

    protected boolean getIgnoreCache() {
        return this._ignoreCache;
    }

    protected boolean verify(String username, char[] password) {
        return this._transaction.verify(username, password);
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    @Override
    public void forceClose() {
        this.persistenceManagerFactory.releasePersistenceManager(this, this._jta);
        this._isClosed = true;
        while (this.current != null) {
            this.current.close();
        }
        Collection c = this._weakCache.values();
        for (StateManager sm : c) {
            sm.release();
        }
        this.disconnectQueries();
        this.persistenceManagerFactory = null;
        this._jta = null;
        this._weakCache.clear();
        this._txCache.clear();
        this._flushedCache.clear();
        this._flushedCache = null;
        this._txCache = null;
        this._weakCache = null;
        this._store = null;
        this._transaction = null;
        this._exclusiveLockHolder = null;
    }

    public void close() {
        this.acquireExclusiveLock();
        try {
            if (this._jta != null) {
                this.persistenceManagerFactory.releasePersistenceManager(this, this._jta);
                this._jta = null;
            }
            if (this.current != null && this._transaction.getTransactionType() != 1) {
                return;
            }
            if (this._activeTransaction || this._flushedCache.size() > 0) {
                throw new JDOException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.close.activetransaction"));
            }
            this.forceClose();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public com.sun.jdo.api.persistence.support.Transaction currentTransaction() {
        this.assertIsOpen();
        return this._transaction;
    }

    public Query newQuery() {
        this.assertIsOpen();
        QueryImpl q = new QueryImpl(this);
        this.registerQuery(q);
        return q;
    }

    public Query newQuery(Object compiled) {
        this.assertIsOpen();
        QueryImpl q = new QueryImpl((PersistenceManager)this, compiled);
        this.registerQuery(q);
        return q;
    }

    public Query newQuery(Class cls) {
        this.assertIsOpen();
        QueryImpl q = new QueryImpl((PersistenceManager)this, cls);
        this.registerQuery(q);
        return q;
    }

    public Query newQuery(Class cls, Collection cln) {
        this.assertIsOpen();
        QueryImpl q = new QueryImpl((PersistenceManager)this, cls, cln);
        this.registerQuery(q);
        return q;
    }

    public Query newQuery(Class cls, String filter) {
        this.assertIsOpen();
        QueryImpl q = new QueryImpl((PersistenceManager)this, cls, filter);
        this.registerQuery(q);
        return q;
    }

    public Query newQuery(Class cls, Collection cln, String filter) {
        this.assertIsOpen();
        QueryImpl q = new QueryImpl(this, cls, cln, filter);
        this.registerQuery(q);
        return q;
    }

    public Collection getExtent(Class persistenceCapableClass, boolean subclasses) {
        this.assertIsOpen();
        return new ExtentCollection(this, persistenceCapableClass, subclasses);
    }

    public Object getObjectById(Object oid) {
        return this.getObjectById(oid, false);
    }

    public Object getObjectById(Object oid, boolean validate) {
        boolean debug = logger.isLoggable(300);
        this.assertIsOpen();
        this.assertActiveTransaction(true);
        Object rc = null;
        if (debug) {
            Object[] items = new Object[]{oid, this, this._jta};
            logger.finest("sqlstore.persistencemgr.getbyobjid", items);
        }
        if (oid == null) {
            return null;
        }
        StateManager sm = this.lookupObjectById(oid, null);
        rc = sm.getPersistent();
        if (!JDOHelper.isTransactional((Object)rc)) {
            boolean foundInstance = this.initializeFromVersionConsistencyCache(sm);
            if (validate && !foundInstance) {
                try {
                    sm.reload();
                }
                catch (JDOException e) {
                    if (!sm.isValid()) {
                        this.deregisterInstance(oid);
                        sm.release();
                    }
                    throw e;
                }
                catch (Exception e) {
                    throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.fetchinstance.none"), e);
                }
            }
        }
        sm.setValid();
        return rc;
    }

    @Override
    public StateManager findOrCreateStateManager(Object oid, Class pcClass) {
        return this.lookupObjectById(oid, pcClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateManager lookupObjectById(Object oid, Class classType) {
        StateManager sm;
        block11: {
            sm = null;
            try {
                this.acquireCacheLock();
                sm = (StateManager)this._weakCache.get(oid);
                if (sm != null) break block11;
                boolean external = false;
                if (classType == null) {
                    classType = this.loadClassForOid(oid);
                    if (classType == null) {
                        throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.getobjectbyid.nometadata"), new Object[]{oid});
                    }
                    external = true;
                }
                try {
                    sm = this.createStateManager(classType);
                    if (external) {
                        oid = this.internalCloneOid(oid, sm);
                    }
                    sm.setObjectId(oid);
                    this.setKeyFields(sm);
                    if (external) {
                        sm.initialize(false);
                    } else {
                        this._weakCache.put(oid, sm);
                    }
                }
                catch (JDOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.fetchinstance.none"), e);
                }
            }
            finally {
                this.releaseCacheLock();
            }
        }
        return sm;
    }

    private StateManager createStateManager(Class classType) {
        StateManager rc = this._store.getStateManager(classType);
        this.newInstance(rc);
        return rc;
    }

    public Object getObjectId(Object pc) {
        boolean debug = logger.isLoggable(300);
        this.assertIsOpen();
        this.assertActiveTransaction(true);
        if (debug) {
            Object[] items = new Object[]{Thread.currentThread(), pc, this, this._jta};
            logger.finest("sqlstore.persistencemgr.getobjid", items);
        }
        try {
            this.assertPersistenceCapable(pc);
        }
        catch (Exception e) {
            if (debug) {
                Object[] items = new Object[]{pc, this};
                logger.finest("sqlstore.persistencemgr.getobjid.notpc", items);
            }
            return null;
        }
        StateManager sm = ((PersistenceCapable)pc).jdoGetStateManager();
        if (sm == null) {
            return null;
        }
        if (sm.getPersistenceManagerInternal() != this) {
            if (debug) {
                Object[] items = new Object[]{pc, this, this._jta};
                logger.finest("sqlstore.persistencemgr.getobjid.notpm", items);
            }
            return null;
        }
        return this.internalGetObjectId(sm);
    }

    public Object getTransactionalInstance(Object pc) {
        this.assertIsOpen();
        this.assertActiveTransaction(false);
        if (!(pc instanceof PersistenceCapable)) {
            return pc;
        }
        PersistenceCapable mypc = (PersistenceCapable)pc;
        PersistenceManagerWrapper pmw = (PersistenceManagerWrapper)mypc.jdoGetPersistenceManager();
        PersistenceManagerImpl pm = (PersistenceManagerImpl)pmw.getPersistenceManager();
        if (pm == null || pm == this) {
            return pc;
        }
        return this.getObjectById(pm.internalGetObjectId(mypc.jdoGetStateManager()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePersistent(Object pc) {
        Object[] items;
        boolean debug = logger.isLoggable(300);
        if (debug) {
            items = new Object[]{Thread.currentThread(), pc, this, this._jta};
            logger.finest("sqlstore.persistencemgr.makepersistent", items);
        }
        if (pc == null) {
            return;
        }
        this.acquireShareLock();
        try {
            this.assertIsOpen();
            this.assertActiveTransaction(false);
            this.assertPersistenceCapable(pc);
            this.internalMakePersistent((PersistenceCapable)pc);
            if (debug) {
                items = new Object[]{pc, this, this._jta};
                logger.finest("sqlstore.persistencemgr.makepersistent.done", items);
            }
        }
        finally {
            this.releaseShareLock();
        }
    }

    public void makePersistent(Object[] pcs) {
        if (pcs == null) {
            return;
        }
        for (int i = 0; i < pcs.length; ++i) {
            this.makePersistent(pcs[i]);
        }
    }

    public void makePersistent(Collection pcs) {
        if (pcs == null) {
            return;
        }
        this.makePersistent(pcs.toArray());
    }

    public void deletePersistent(Object pc) {
        if (pc == null) {
            return;
        }
        this.acquireShareLock();
        try {
            this.assertIsOpen();
            this.assertActiveTransaction(false);
            this.assertPersistenceCapable(pc);
            this.internalDeletePersistent((PersistenceCapable)pc);
        }
        finally {
            this.releaseShareLock();
        }
    }

    public void deletePersistent(Object[] pcs) {
        if (pcs == null) {
            return;
        }
        for (int i = 0; i < pcs.length; ++i) {
            this.deletePersistent(pcs[i]);
        }
    }

    public void deletePersistent(Collection pcs) {
        if (pcs == null) {
            return;
        }
        this.deletePersistent(pcs.toArray());
    }

    public com.sun.jdo.api.persistence.support.PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    void setPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        if (this.persistenceManagerFactory == null) {
            this.persistenceManagerFactory = pmf;
        }
    }

    public void setUserObject(Object o) {
        this._userObject = o;
    }

    public Object getUserObject() {
        return this._userObject;
    }

    public Properties getProperties() {
        if (this._properties == null) {
            this._properties = RuntimeVersion.getVendorProperties("/com/sun/jdo/spi/persistence/support/sqlstore/sys.properties");
        }
        return this._properties;
    }

    public boolean getSupersedeDeletedInstance() {
        return this._supersedeDeletedInstance;
    }

    public void setSupersedeDeletedInstance(boolean flag) {
        this._supersedeDeletedInstance = flag;
    }

    public boolean getRequireCopyObjectId() {
        return this._requireCopyObjectId;
    }

    public void setRequireCopyObjectId(boolean flag) {
        this._requireCopyObjectId = flag;
    }

    public boolean getRequireTrackedSCO() {
        return this._requireTrackedSCO;
    }

    public void setRequireTrackedSCO(boolean flag) {
        this._requireTrackedSCO = flag;
    }

    public Class getObjectIdClass(Class cls) {
        PersistenceConfig config = this.loadPersistenceConfig(cls);
        return config.getOidClass();
    }

    @Override
    public Object newInstance(StateManager sm) {
        Object o = null;
        PersistenceConfig config = sm.getPersistenceConfig();
        if (config == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.newinstance.badsm"));
        }
        Constructor constr = config.getConstructor();
        try {
            if (constr != null) {
                o = constr.newInstance(sm);
                sm.setPersistenceManager(this);
                sm.setPersistent(o);
            }
        }
        catch (Exception e) {
            throw new JDOFatalUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.assertpersistencecapable.error", (String)config.getPersistenceCapableClass().getName()), e);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object retrieve(RetrieveDesc action, ValueFetcher parameters) {
        this.acquireShareLock();
        try {
            this.assertActiveTransaction(true);
            Object object = this._store.retrieve(this, action, parameters);
            return object;
        }
        finally {
            this.releaseShareLock();
        }
    }

    @Override
    public Object retrieve(RetrieveDesc action) {
        return this.retrieve(action, null);
    }

    @Override
    public RetrieveDesc getRetrieveDesc(Class classType) {
        this.acquireShareLock();
        try {
            this.loadPersistenceConfig(classType);
            RetrieveDesc retrieveDesc = this._store.getRetrieveDesc(classType);
            return retrieveDesc;
        }
        finally {
            this.releaseShareLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetrieveDesc getRetrieveDesc(String fieldName, Class classType) {
        this.acquireShareLock();
        try {
            this.loadPersistenceConfig(classType);
            RetrieveDesc retrieveDesc = this._store.getRetrieveDesc(fieldName, classType);
            return retrieveDesc;
        }
        finally {
            this.releaseShareLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInstance(StateManager sm, Object oid) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{Thread.currentThread(), oid, this, this._jta};
            logger.finest("sqlstore.persistencemgr.registerinstance", items);
        }
        try {
            this.acquireCacheLock();
            if (debug) {
                logger.finest("sqlstore.persistencemgr.registerinstancein_wkc");
            }
            this._weakCache.put(oid, sm);
            if (sm.needsRegisterWithVersionConsistencyCache()) {
                this.addToVersionConsistencyCache(sm);
            }
        }
        finally {
            this.releaseCacheLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInstance(StateManager sm, Object oid, boolean throwDuplicateException, boolean forceRegister) {
        Object[] items;
        boolean debug;
        if (oid == null) {
            oid = sm.getObjectId();
        }
        if (debug = logger.isLoggable()) {
            items = new Object[]{Thread.currentThread(), oid, sm, this, this._jta};
            logger.finest("sqlstore.persistencemgr.registerinstance", items);
        }
        try {
            this.acquireCacheLock();
            if (!this._weakCache.containsKey(oid)) {
                if (debug) {
                    logger.finest("sqlstore.persistencemgr.registerinstancein_wkc");
                }
                this._weakCache.put(oid, sm);
            } else if (throwDuplicateException) {
                StateManager old = (StateManager)this._weakCache.get(oid);
                if (this._supersedeDeletedInstance && old.isDeleted()) {
                    if (debug) {
                        logger.finer(I18NHelper.getMessage((ResourceBundle)messages, (String)"sqlstore.persistencemgr.replacingdeletedinstance", (Object)oid));
                    }
                    old.markNotRegistered();
                    old.markVerifyAtDeregister();
                    sm.markVerifyAtDeregister();
                    sm.markReplacement();
                    old.addDependency(sm);
                    this._weakCache.put(oid, sm);
                    return;
                }
                throw new JDODuplicateObjectIdException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.internalmakepersistent.dups"), new Object[]{sm.getPersistent()});
            }
            if (this._activeTransaction && (sm.isTransactional() || forceRegister)) {
                if (debug) {
                    items = new Object[]{oid, sm.getPersistent(), this, this._jta};
                    logger.finest("sqlstore.persistencemgr.registerinstancein_txc", items);
                }
                if (sm.isDirty()) {
                    this._txCache.add(sm);
                }
                this._flushedCache.add(sm);
                if (sm.needsRegisterWithVersionConsistencyCache()) {
                    this.addToVersionConsistencyCache(sm);
                }
            }
        }
        finally {
            this.releaseCacheLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterInstance(Object oid) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{oid, this, this._jta};
            logger.finest("sqlstore.persistencemgr.deregisterinstance", items);
        }
        if (oid != null) {
            try {
                this.acquireCacheLock();
                StateManager sm = (StateManager)this._weakCache.remove(oid);
                this.removeFromCaches(sm);
            }
            finally {
                this.releaseCacheLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterInstance(Object oid, StateManager sm) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{oid, this, this._jta};
            logger.finest("sqlstore.persistencemgr.deregisterinstance.verify", items);
        }
        try {
            this.acquireCacheLock();
            Object known = this._weakCache.get(oid);
            if (known == sm) {
                this._weakCache.remove(oid);
                if (debug) {
                    logger.finest("sqlstore.persistencemgr.deregisterinstance.verified");
                }
            }
            this.removeFromCaches(sm);
        }
        finally {
            this.releaseCacheLock();
        }
    }

    private void removeFromCaches(StateManager sm) {
        if (sm != null) {
            if (this._activeTransaction) {
                this._txCache.remove(sm);
                this._flushedCache.remove(sm);
            }
            this.removeFromVersionConsistencyCache(sm);
        }
    }

    @Override
    public void beforeCompletion() {
        if (logger.isLoggable(300)) {
            logger.finest("sqlstore.persistencemgr.beforecompletion");
        }
        this.assertIsOpen();
        this.assertActiveTransaction(false);
        this._insideCommit = true;
        this.prepareToUpdate();
        try {
            this.flushTxCache();
            if (!this._insideFlush) {
                this.verifyFlushedCache();
            }
        }
        catch (JDODataStoreException ex) {
            this.cleanupVersionConsistencyCache = true;
            throw ex;
        }
    }

    private void prepareToUpdate() {
        for (int i = 0; i < this._txCache.size(); ++i) {
            StateManager sm = (StateManager)this._txCache.get(i);
            sm.prepareToUpdatePhaseI();
        }
        if (!this._insideFlush) {
            java.util.HashSet phase3sms = new java.util.HashSet();
            for (StateManager sm : this._flushedCache) {
                sm.prepareToUpdatePhaseII(phase3sms);
            }
            for (StateManager sm : phase3sms) {
                sm.prepareToUpdatePhaseIII();
            }
        }
    }

    private void flushTxCache() {
        List err = PersistenceManagerImpl.flushToDataStore(this._txCache);
        if (err != null && err.size() > 0) {
            Iterator iter = err.iterator();
            while (iter.hasNext()) {
                ((StateManager)iter.next()).resolveDependencies();
            }
            err = PersistenceManagerImpl.flushToDataStore(err);
        }
        if (err != null && err.size() > 0) {
            this._transaction.setRollbackOnly();
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.notprocessed"), PersistenceManagerImpl.toPCArray(err));
        }
    }

    private void verifyFlushedCache() {
        for (StateManager sm : this._flushedCache) {
            if (!sm.hasVersionConsistency() || sm.verifyPersistent()) continue;
            Object[] items = new Object[]{sm.getPersistent()};
            sm.setVerificationFailed();
            throw new JDODataStoreException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.verificationfailed"), items);
        }
    }

    private static List flushToDataStore(List flushList) {
        StateManager sm;
        int i;
        int size = flushList.size();
        ArrayList<StateManager> errorList = null;
        for (i = 0; i < size; ++i) {
            sm = (StateManager)flushList.get(i);
            StateManager smNext = i + 1 < size ? (StateManager)flushList.get(i + 1) : null;
            sm.updatePersistent(smNext);
        }
        for (i = 0; i < size; ++i) {
            sm = (StateManager)flushList.get(i);
            if (sm.isProcessed()) continue;
            if (errorList == null) {
                errorList = new ArrayList<StateManager>();
            }
            errorList.add(sm);
        }
        return errorList;
    }

    private static Object[] toPCArray(List smList) {
        int size = smList.size();
        if (size > 0) {
            ArrayList<Object> pcList = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                StateManager sm = (StateManager)smList.get(i);
                pcList.add(sm.getPersistent());
            }
            return pcList.toArray();
        }
        return null;
    }

    @Override
    public void afterCompletion(int status) {
        this.assertIsOpen();
        this._insideCommit = true;
        boolean abort = status == 4 || status == 9 || status == 1;
        boolean debug = false;
        debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.persistencemgr.aftercompletion", (Object)new Boolean(abort));
        }
        boolean retainValues = this._transaction.getRetainValues();
        for (StateManager sm : this._flushedCache) {
            if (debug) {
                logger.finest("sqlstore.persistencemgr.aftercompletion.process", sm.getObjectId());
            }
            if (abort) {
                this.rollback(sm, retainValues);
                continue;
            }
            this.commit(sm, retainValues);
        }
        this._txCache.clear();
        this._flushedCache.clear();
        this._insideCommit = false;
        this.cleanupVersionConsistencyCache = false;
    }

    private void commit(StateManager sm, boolean retainValues) {
        if (sm.needsUpdateInVersionConsistencyCache()) {
            StateManager nonTxSM = this.lookupFromVersionConsistencyCache(sm);
            if (null != nonTxSM) {
                nonTxSM.copyFields(sm);
            } else {
                this.addToVersionConsistencyCache(sm);
            }
        }
        sm.commit(retainValues);
    }

    private void rollback(StateManager sm, boolean retainValues) {
        if (this.cleanupVersionConsistencyCache && sm.isVerificationFailed()) {
            this.removeFromVersionConsistencyCache(sm);
        }
        sm.rollback(retainValues);
    }

    private StateManager addToVersionConsistencyCache(StateManager sm) {
        StateManager rc = null;
        if (null != sm && sm.hasVersionConsistency()) {
            Class<?> pcType = sm.getPersistent().getClass();
            Object oid = sm.getObjectId();
            VersionConsistencyCache vcCache = this.persistenceManagerFactory.getVersionConsistencyCache();
            if (vcCache.get(pcType, oid) == null) {
                StateManager nonTxSM = this.createStateManager(pcType);
                nonTxSM.copyFields(sm);
                nonTxSM.setPersistenceManager(null);
                rc = vcCache.put(pcType, oid, nonTxSM);
            }
        }
        return rc;
    }

    private StateManager removeFromVersionConsistencyCache(StateManager sm) {
        StateManager rc = null;
        if (null != sm && sm.hasVersionConsistency()) {
            Class<?> pcType = sm.getPersistent().getClass();
            Object oid = sm.getObjectId();
            VersionConsistencyCache vcCache = this.persistenceManagerFactory.getVersionConsistencyCache();
            rc = vcCache.remove(pcType, oid);
            if (null == rc) {
                // empty if block
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initializeFromVersionConsistencyCache(StateManager sm) {
        boolean rc = false;
        StateManager nonTxSM = this.lookupFromVersionConsistencyCache(sm);
        if (null != nonTxSM) {
            rc = true;
            StateManager stateManager = nonTxSM;
            synchronized (stateManager) {
                sm.copyFields(nonTxSM);
            }
            sm.initialize(true);
        }
        return rc;
    }

    private StateManager lookupFromVersionConsistencyCache(StateManager sm) {
        StateManager rc = null;
        if (null != sm && sm.hasVersionConsistency()) {
            Class<?> pcType = sm.getPersistent().getClass();
            Object oid = sm.getObjectId();
            VersionConsistencyCache vcCache = this.persistenceManagerFactory.getVersionConsistencyCache();
            rc = vcCache.get(pcType, oid);
        }
        return rc;
    }

    @Override
    public void setStateManager(Object pc, StateManager sm) {
        if (pc instanceof PersistenceCapable) {
            ((PersistenceCapable)pc).jdoSetStateManager(sm);
        }
    }

    @Override
    public void setFlags(Object pc, byte flags) {
        if (pc instanceof PersistenceCapable) {
            ((PersistenceCapable)pc).jdoSetFlags(flags);
        }
    }

    @Override
    public byte getFlags(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoGetFlags();
        }
        return 0;
    }

    @Override
    public StateManager getStateManager(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoGetStateManager();
        }
        return null;
    }

    @Override
    public void setField(Object o, int fieldNumber, Object value) {
        if (o instanceof PersistenceCapable) {
            PersistenceCapable pc = (PersistenceCapable)o;
            pc.jdoSetField(fieldNumber, value);
        }
    }

    @Override
    public Object getField(Object pc, int fieldNumber) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoGetField(fieldNumber);
        }
        return null;
    }

    @Override
    public void clearFields(Object pc) {
        if (pc instanceof PersistenceCapable) {
            ((PersistenceCapable)pc).jdoClear();
        }
    }

    public Object newSCOInstance(Class type, Object owner, String fieldName) {
        Object obj = null;
        obj = Collection.class.isAssignableFrom(type) ? this.newCollectionInstanceInternal(type, owner, fieldName, null, true, 0) : this.newSCOInstanceInternal(type, owner, fieldName);
        this.replaceSCO(fieldName, owner, obj);
        return obj;
    }

    @Override
    public Object newSCOInstanceInternal(Class type, Object owner, String fieldName) {
        java.util.Date obj = null;
        if (type == Date.class || type == SqlDate.class) {
            obj = new SqlDate(owner, fieldName);
        } else if (type == Time.class || type == SqlTime.class) {
            obj = new SqlTime(owner, fieldName);
        } else if (type == Timestamp.class || type == SqlTimestamp.class) {
            obj = new SqlTimestamp(owner, fieldName);
        } else if (type == com.sun.jdo.spi.persistence.support.sqlstore.sco.Date.class || java.util.Date.class.isAssignableFrom(type)) {
            obj = new com.sun.jdo.spi.persistence.support.sqlstore.sco.Date(owner, fieldName);
        } else {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.newscoinstance.wrongclass", (String)type.getName()));
        }
        return obj;
    }

    public Object newCollectionInstance(Class type, Object owner, String fieldName, Class elementType, boolean allowNulls, int initialSize) {
        Object obj = this.newCollectionInstanceInternal(type, owner, fieldName, elementType, allowNulls, initialSize);
        this.replaceSCO(fieldName, owner, obj);
        return obj;
    }

    @Override
    public Object newCollectionInstanceInternal(Class type, Object owner, String fieldName, Class elementType, boolean allowNulls, int initialSize) {
        HashSet obj = null;
        if (type == java.util.HashSet.class || type == HashSet.class) {
            if (initialSize == 0) {
                initialSize = 101;
            }
            obj = new HashSet(owner, fieldName, elementType, allowNulls, initialSize);
        } else if (Set.class.isAssignableFrom(type)) {
            if (initialSize == 0) {
                initialSize = 101;
            }
            obj = new HashSet(owner, fieldName, elementType, allowNulls, initialSize);
        } else if (Collection.class.isAssignableFrom(type)) {
            if (initialSize == 0) {
                initialSize = 101;
            }
            obj = new HashSet(owner, fieldName, elementType, allowNulls, initialSize);
        } else {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.newscoinstance.wrongclass", (String)type.getName()));
        }
        boolean debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.persistencemgr.newcollection", obj.getClass());
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalFlush() {
        this.acquireExclusiveLock();
        try {
            if (!this._optimistic) {
                this._insideFlush = true;
                this.beforeCompletion();
                this._insideCommit = false;
                int status = this._transaction.getStatus();
                if (status == 4 || status == 9 || status == 1) {
                    return;
                }
                for (int i = 0; i < this._txCache.size(); ++i) {
                    StateManager sm = (StateManager)this._txCache.get(i);
                    sm.flushed();
                }
                this._insideFlush = false;
                this._txCache.clear();
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public synchronized void notifyStatusChange(boolean isActive) {
        this._activeTransaction = isActive;
    }

    @Override
    public synchronized void notifyOptimistic(boolean optimistic) {
        this._optimistic = optimistic;
    }

    @Override
    public boolean isOptimisticTransaction() {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.persistencemgr.isoptimistic", (Object)new Boolean(this._optimistic));
        }
        return this._optimistic;
    }

    @Override
    public synchronized void notifyNontransactionalRead(boolean nontransactionalRead) {
        this._nontransactionalRead = nontransactionalRead;
    }

    @Override
    public boolean isNontransactionalRead() {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.persistencemgr.isnontxread", (Object)new Boolean(this._nontransactionalRead));
        }
        return this._nontransactionalRead;
    }

    @Override
    public boolean isActiveTransaction() {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.persistencemgr.isactivetx", (Object)new Boolean(this._activeTransaction));
        }
        return this._activeTransaction;
    }

    @Override
    public PersistenceManagerWrapper getCurrentWrapper() {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.persistencemgr.getcurrentwrapper", (Object)this.current);
        }
        return this.current;
    }

    protected void pushCurrentWrapper(PersistenceManagerWrapper pmw) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{this.current, pmw};
            logger.finest("sqlstore.persistencemgr.pushcurrentwrapper", items);
        }
        this.current = pmw;
    }

    protected void popCurrentWrapper(PersistenceManagerWrapper prev) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{this.current, prev};
            logger.finest("sqlstore.persistencemgr.popcurrentwrapper", items);
        }
        this.current = prev;
        if (!this._isClosed && this._jta == null && this.current == null) {
            this.close();
        }
    }

    protected void setJTATransaction(Transaction t) {
        if (this._jta != null) {
            Object[] items = new Object[]{this._jta, t};
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.setjtatransaction.notnulljta", (Object[])items));
        }
        this._jta = t;
    }

    private void registerQuery(QueryImpl q) {
        this.acquireExclusiveLock();
        try {
            this.queries.add(q);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void disconnectQueries() {
        for (QueryImpl q : this.queries) {
            q.clearPersistenceManager();
        }
        this.queries.clear();
        this.queries = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSCO(String fieldName, Object owner, Object obj) {
        block8: {
            if (owner instanceof PersistenceCapable) {
                this.acquireShareLock();
                try {
                    PersistenceCapable pc = (PersistenceCapable)owner;
                    StateManager sm = pc.jdoGetStateManager();
                    if (obj instanceof SCOCollection) {
                        this.acquireFieldUpdateLock();
                        try {
                            sm.replaceObjectField(fieldName, obj);
                            break block8;
                        }
                        finally {
                            this.releaseFieldUpdateLock();
                        }
                    }
                    sm.replaceObjectField(fieldName, obj);
                }
                finally {
                    this.releaseShareLock();
                }
            }
        }
    }

    private Object internalGetObjectId(StateManager sm) {
        Object oid = sm.getObjectId();
        return this.internalCloneOid(oid, sm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalMakePersistent(PersistenceCapable pc) {
        this.acquireFieldUpdateLock();
        try {
            PersistenceCapable persistenceCapable = pc;
            synchronized (persistenceCapable) {
                StateManager sm = null;
                if (pc.jdoIsPersistent()) {
                    sm = pc.jdoGetStateManager();
                    if (this != pc.jdoGetStateManager().getPersistenceManagerInternal()) {
                        throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.another_pm"), new Object[]{pc});
                    }
                } else {
                    Class<?> classType = pc.getClass();
                    this.loadPersistenceConfig(classType);
                    sm = this._store.getStateManager(classType);
                }
                sm.makePersistent(this, pc);
            }
        }
        finally {
            this.releaseFieldUpdateLock();
        }
    }

    private void internalDeletePersistent(PersistenceCapable pc) {
        if (!pc.jdoIsPersistent()) {
            throw new JDOException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.internaldeletepersistent.transient"), new Object[]{pc});
        }
        StateManager sm = pc.jdoGetStateManager();
        PersistenceManager pm = (PersistenceManager)sm.getPersistenceManagerInternal();
        if (this != pm) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.another_pm"), new Object[]{pc});
        }
        if (!pc.jdoIsDeleted()) {
            sm.deletePersistent();
        }
    }

    private Class loadClassForOid(Object oid) {
        Class<?> oidClass = oid.getClass();
        Class classType = this._store.getClassByOidClass(oidClass);
        if (classType != null) {
            return classType;
        }
        this.loadByName(oidClass.getName(), oidClass.getClassLoader());
        return this._store.getClassByOidClass(oidClass);
    }

    private void loadByName(String s, ClassLoader classLoader) {
        int l = s.length();
        if (l < 4) {
            return;
        }
        String s1 = s.substring(l - 3);
        if (s1.equalsIgnoreCase(oidName_OID) && (s.charAt(l - 4) == '.' || s.charAt(l - 4) == '$')) {
            s = s.substring(0, l - 4);
        } else if (s1.equalsIgnoreCase(oidName_KEY)) {
            s = s.substring(0, l - 3);
        } else {
            return;
        }
        boolean debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.persistencemgr.loadingclass", (Object)s);
        }
        Class<?> oidClass = null;
        try {
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            oidClass = Class.forName(s, true, classLoader);
        }
        catch (Exception e) {
            throw new JDOFatalUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.loadclassforoid.wrongoidclass"), e);
        }
        this.loadPersistenceConfig(oidClass);
    }

    private void assertIsOpen() {
        if (this._isClosed) {
            boolean debug = logger.isLoggable(300);
            if (debug) {
                logger.finest("sqlstore.persistencemgr.assertisopen", (Object)this);
            }
            throw new JDOFatalUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.assertclosed.closed"));
        }
    }

    private void assertActiveTransaction(boolean insideQuery) {
        boolean debug = false;
        debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.persistencemgr.assertactivetx", (Object)this._transaction);
        }
        if (this._insideCommit || insideQuery && this._transaction.getNontransactionalRead()) {
            return;
        }
        if (!this._activeTransaction) {
            if (debug) {
                logger.finest("sqlstore.persistencemgr.assertactivetx.closed", (Object)this);
            }
            throw new JDOException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.assertactivetransaction.error"));
        }
    }

    private void assertPersistenceCapable(Object pc) {
        if (!(pc instanceof PersistenceCapable)) {
            throw new JDOException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.assertpersistencecapable.error", (String)pc.getClass().getName()), new Object[]{pc});
        }
    }

    private void setKeyFields(StateManager sm) {
        block4: {
            Object o = sm.getPersistent();
            if (o == null) {
                return;
            }
            Object oid = sm.getObjectId();
            try {
                PersistenceConfig config = sm.getPersistenceConfig();
                Field[] keyFields = config.getKeyFields();
                String[] keynames = config.getKeyFieldNames();
                for (int i = 0; i < keyFields.length; ++i) {
                    Field keyField = keyFields[i];
                    sm.makePresent(keynames[i], keyField.get(oid));
                }
            }
            catch (Exception e) {
                boolean debug = logger.isLoggable(300);
                if (!debug) break block4;
                logger.finest("sqlstore.persistencemgr.setkeyfields", (Object)e);
            }
        }
    }

    private PersistenceConfig loadPersistenceConfig(Class classType) {
        return this._store.getPersistenceConfig(classType);
    }

    private Object internalCloneOid(Object oid, StateManager sm) {
        if (oid == null) {
            return null;
        }
        if (!this._requireCopyObjectId) {
            return oid;
        }
        boolean debug = logger.isLoggable(300);
        Object newoid = null;
        try {
            Class<?> oidClass = oid.getClass();
            newoid = oidClass.newInstance();
            PersistenceConfig config = sm.getPersistenceConfig();
            Field[] keyFields = config.getKeyFields();
            for (int i = 0; i < keyFields.length; ++i) {
                Field keyField = keyFields[i];
                keyField.set(newoid, keyField.get(oid));
            }
        }
        catch (Exception e) {
            if (debug) {
                logger.finest("sqlstore.persistencemgr.internalcloneoid", (Object)e);
            }
            newoid = null;
        }
        if (debug) {
            Object[] items = new Object[]{oid, newoid, new Boolean(oid == newoid)};
            logger.finest("sqlstore.persistencemgr.internalcloneoid.old", items);
        }
        return newoid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireShareLock() {
        if (!this._multithreaded) {
            return;
        }
        boolean debug = logger.isLoggable(300);
        Object object = this._readWriteLock;
        synchronized (object) {
            if (this._readWriteCount < 0L && this._exclusiveLockHolder == Thread.currentThread()) {
                return;
            }
            while (this._readWriteCount < 0L) {
                ++this._waiterCount;
                try {
                    if (debug) {
                        logger.finest("sqlstore.persistencemgr.acquiresharedlock", (Object)Thread.currentThread());
                    }
                    this._readWriteLock.wait();
                }
                catch (InterruptedException e) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.acquiresharelock.interrupted"), (Exception)e);
                }
                finally {
                    --this._waiterCount;
                }
            }
            try {
                this.assertIsOpen();
            }
            catch (JDOException ex) {
                if (this._readWriteCount == 0L && this._waiterCount > 0L) {
                    this._readWriteLock.notify();
                }
                throw ex;
            }
            ++this._readWriteCount;
            if (debug) {
                logger.finest("sqlstore.persistencemgr.acquiresharedlock.rdwrcount", (Object)Thread.currentThread(), (Object)new Long(this._readWriteCount));
            }
            if (this._readWriteCount <= 0L) {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.acquiresharelock.failed"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void releaseShareLock() {
        if (!this._multithreaded) {
            return;
        }
        boolean debug = logger.isLoggable(300);
        Object object = this._readWriteLock;
        synchronized (object) {
            if (this._readWriteCount < 0L && this._exclusiveLockHolder == Thread.currentThread()) {
                return;
            }
            try {
                if (this._readWriteCount == 0L) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.releasesharelock.failed"));
                }
                --this._readWriteCount;
                if (this._waiterCount > 0L && this._readWriteCount == 0L) {
                    this._readWriteLock.notify();
                }
                if (!debug) return;
            }
            catch (Throwable throwable) {
                if (this._waiterCount > 0L && this._readWriteCount == 0L) {
                    this._readWriteLock.notify();
                }
                if (!debug) throw throwable;
                Object[] items = new Object[]{Thread.currentThread(), new Long(this._readWriteCount)};
                logger.finest("sqlstore.persistencemgr.releasesharedlock", items);
                throw throwable;
            }
            Object[] items = new Object[]{Thread.currentThread(), new Long(this._readWriteCount)};
            logger.finest("sqlstore.persistencemgr.releasesharedlock", items);
            {
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireExclusiveLock() {
        if (!this._multithreaded) {
            return;
        }
        boolean debug = logger.isLoggable(300);
        Object object = this._readWriteLock;
        synchronized (object) {
            Thread currentThread = Thread.currentThread();
            if (currentThread == this._exclusiveLockHolder) {
                --this._readWriteCount;
            } else {
                while (this._readWriteCount != 0L) {
                    ++this._waiterCount;
                    try {
                        if (debug) {
                            logger.finest("sqlstore.persistencemgr.acquireexclusivelock", (Object)currentThread);
                        }
                        this._readWriteLock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.acquireexclusivelock.interrupted"), (Exception)e);
                    }
                    finally {
                        --this._waiterCount;
                    }
                }
                try {
                    this.assertIsOpen();
                }
                catch (JDOException ex) {
                    if (this._readWriteCount == 0L && this._waiterCount > 0L) {
                        this._readWriteLock.notify();
                    }
                    throw ex;
                }
                this._readWriteCount = -1L;
                this._exclusiveLockHolder = currentThread;
                if (debug) {
                    Object[] items = new Object[]{currentThread, new Long(this._readWriteCount)};
                    logger.fine("sqlstore.persistencemgr.acquireexclusivelock.count", items);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseExclusiveLock() {
        if (!this._multithreaded) {
            return;
        }
        boolean debug = logger.isLoggable(300);
        Object object = this._readWriteLock;
        synchronized (object) {
            block12: {
                try {
                    if (this._readWriteCount >= 0L) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jdo.persistencemanagerimpl.releaseexclusivelock.failed"));
                    }
                    ++this._readWriteCount;
                    if (!debug) break block12;
                }
                catch (Throwable throwable) {
                    if (debug) {
                        Object[] items = new Object[]{Thread.currentThread(), new Long(this._readWriteCount)};
                        logger.finest("sqlstore.persistencemgr.releaseexclusivelock", items);
                    }
                    if (this._readWriteCount == 0L) {
                        if (this._waiterCount > 0L) {
                            this._readWriteLock.notify();
                        }
                        this._exclusiveLockHolder = null;
                    }
                    throw throwable;
                }
                Object[] items = new Object[]{Thread.currentThread(), new Long(this._readWriteCount)};
                logger.finest("sqlstore.persistencemgr.releaseexclusivelock", items);
            }
            if (this._readWriteCount == 0L) {
                if (this._waiterCount > 0L) {
                    this._readWriteLock.notify();
                }
                this._exclusiveLockHolder = null;
            }
        }
    }

    @Override
    public void acquireFieldUpdateLock() {
        this._fieldUpdateLock.acquire();
    }

    @Override
    public void releaseFieldUpdateLock() {
        this._fieldUpdateLock.release();
    }

    @Override
    public void acquireCacheLock() {
        this._cacheLock.acquire();
    }

    @Override
    public void releaseCacheLock() {
        this._cacheLock.release();
    }

    static {
        float f = 0.75f;
        try {
            f = Float.valueOf(System.getProperty("com.sun.jdo.api.persistence.support.PersistenceManager.transactionalCache.loadFactor", "0.75")).floatValue();
        }
        finally {
            _flushedCacheLoadFactor = f;
        }
        _weakCacheInitialCapacity = Integer.getInteger("com.sun.jdo.api.persistence.support.PersistenceManager.globalCache.initialCapacity", 20);
        f = 0.75f;
        try {
            f = Float.valueOf(System.getProperty("com.sun.jdo.api.persistence.support.PersistenceManager.globalCache.loadFactor", "0.75")).floatValue();
        }
        finally {
            _weakCacheLoadFactor = f;
        }
        logger = LogHelperPersistenceManager.getLogger();
        messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (ClassLoader)PersistenceManagerImpl.class.getClassLoader());
    }

    static class ExtensionFilter
    implements FilenameFilter {
        private String ext;

        public ExtensionFilter(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.ext);
        }
    }
}

