/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

abstract class XMLStreamReaderFilter
extends StreamReaderDelegate {
    XMLStreamReaderFilter(XMLStreamReader reader) {
        super(reader);
    }

    XMLStreamReaderFilter() {
    }

    @Override
    public int next() throws XMLStreamException {
        int r;
        while ((r = super.next()) == 1 && this.filterOut()) {
            this.skipTree();
        }
        return r;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int r;
        while ((r = this.thisNextTag()) == 1 && this.filterOut()) {
            this.skipTree();
        }
        return r;
    }

    private int thisNextTag() throws XMLStreamException {
        int eventType = super.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5 || eventType == 11) {
            eventType = super.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("found: " + XMLStreamReaderFilter.getEventTypeString(eventType) + ", expected " + XMLStreamReaderFilter.getEventTypeString(1) + " or " + XMLStreamReaderFilter.getEventTypeString(2));
        }
        return eventType;
    }

    static final String getEventTypeString(int eventType) {
        switch (eventType) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 6: {
                return "SPACE";
            }
        }
        return "UNKNOWN_EVENT_TYPE, " + String.valueOf(eventType);
    }

    private void skipTree() throws XMLStreamException {
        int depth = 1;
        while (depth > 0) {
            int r = super.next();
            if (r == 1) {
                ++depth;
                continue;
            }
            if (r != 2) continue;
            --depth;
        }
    }

    abstract boolean filterOut() throws XMLStreamException;
}

