/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@Service(name="delete-log-levels")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="delete.log.levels")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.DELETE, path="delete-log-levels", description="delete-log-levels")})
public class DeleteLogLevel
implements AdminCommand {
    @Param(name="logger_name", primary=true, separator=58)
    String properties;
    @Param(optional=true)
    String target = "server";
    @Inject
    LoggingConfigImpl loggingConfig;
    @Inject
    Domain domain;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteLogLevel.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        boolean isCluster = false;
        boolean isDas = false;
        boolean isInstance = false;
        StringBuffer successMsg = new StringBuffer();
        boolean isConfig = false;
        boolean success = false;
        String targetConfigName = "";
        HashMap<String, Object> m = new HashMap<String, Object>();
        try {
            Server targetServer;
            String[] loggerNames;
            String[] stringArray = loggerNames = this.properties.split(":");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String key;
                String logger_name = key = stringArray[i];
                m.put(logger_name + ".level", null);
            }
            Config config = this.domain.getConfigNamed(this.target);
            if (config != null) {
                targetConfigName = this.target;
                isConfig = true;
                targetServer = this.domain.getServerNamed("server");
                if (targetServer != null && targetServer.getConfigRef().equals(this.target)) {
                    isDas = true;
                }
                targetServer = null;
            } else {
                Cluster clusterForInstance;
                targetServer = this.domain.getServerNamed(this.target);
                if (targetServer != null && targetServer.isDas()) {
                    isDas = true;
                } else {
                    Cluster cluster = this.domain.getClusterNamed(this.target);
                    if (cluster != null) {
                        isCluster = true;
                        targetConfigName = cluster.getConfigRef();
                    } else if (targetServer != null) {
                        isInstance = true;
                        targetConfigName = targetServer.getConfigRef();
                    }
                }
                if (isInstance && (clusterForInstance = targetServer.getCluster()) != null) {
                    targetConfigName = clusterForInstance.getConfigRef();
                }
            }
            if (isCluster || isInstance) {
                this.loggingConfig.deleteLoggingProperties(m, targetConfigName);
                success = true;
            } else if (isDas) {
                this.loggingConfig.deleteLoggingProperties(m);
                success = true;
            } else if (isConfig) {
                this.loggingConfig.deleteLoggingProperties(m, targetConfigName);
                success = true;
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target: {0}. Valid default target is a server named ''server'' (default) or cluster name.", new Object[]{this.target});
                report.setMessage(msg);
                return;
            }
            if (success) {
                successMsg.append(localStrings.getLocalString("delete.log.level.success", "These logging levels are deleted for {0}.", new Object[]{this.target}));
                report.setMessage(successMsg.toString());
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
        }
        catch (IOException e) {
            report.setMessage(localStrings.getLocalString("delete.log.level.failed", "Could not delete logger levels for {0}.", new Object[]{this.target}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

