/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.cmp;

import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.api.persistence.support.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.JDOEJB20Helper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import javax.ejb.EJBLocalObject;

public class EJBHashSet
extends HashSet {
    private PersistenceManager pm = null;
    private Transaction tx = null;
    private HashSet pcSet = null;
    private JDOEJB20Helper helper = null;
    private boolean valid = false;
    private static Logger logger = LogHelperSQLStore.getLogger();

    public EJBHashSet(PersistenceManager pm, JDOEJB20Helper helper, Collection pcs) {
        this.pm = pm;
        this.tx = pm.currentTransaction();
        this.helper = helper;
        this.setSCOHashSet(pcs);
        this.valid = true;
    }

    @Override
    public boolean add(Object o) {
        logger.finest("---EJBHashSet.add---");
        this.assertIsValid();
        this.assertInTransaction();
        this.helper.assertInstanceOfLocalInterfaceImpl(o);
        Object pc = this.helper.convertEJBLocalObjectToPC((EJBLocalObject)o, this.pm, true);
        return this.pcSet.add(pc);
    }

    @Override
    public boolean addAll(Collection c) {
        logger.finest("---EJBHashSet.addAll---");
        this.assertIsValid();
        this.assertInTransaction();
        this.assertInstancesOfLocalInterfaceImpl(c);
        return this.pcSet.addAll(this.helper.convertCollectionEJBLocalObjectToPC(c, this.pm, true));
    }

    @Override
    public boolean remove(Object o) {
        logger.finest("---EJBHashSet.remove---");
        this.assertIsValid();
        this.assertInTransaction();
        this.helper.assertInstanceOfLocalInterfaceImpl(o);
        EJBLocalObject lo = (EJBLocalObject)o;
        return this.pcSet.remove(this.helper.convertEJBLocalObjectToPC(lo, this.pm, true));
    }

    @Override
    public boolean removeAll(Collection c) {
        logger.finest("---EJBHashSet.removeAll---");
        this.assertIsValid();
        this.assertInTransaction();
        this.assertInstancesOfLocalInterfaceImpl(c);
        return this.pcSet.removeAll(this.helper.convertCollectionEJBLocalObjectToPC(c, this.pm, true));
    }

    @Override
    public boolean retainAll(Collection c) {
        logger.finest("---EJBHashSet.retainAll---");
        this.assertIsValid();
        this.assertInTransaction();
        this.assertInstancesOfLocalInterfaceImpl(c);
        return this.pcSet.retainAll(this.helper.convertCollectionEJBLocalObjectToPC(c, this.pm, true));
    }

    @Override
    public void clear() {
        logger.finest("---EJBHashSet.clear---");
        this.assertIsValid();
        this.assertInTransaction();
        this.pcSet.clear();
    }

    @Override
    public int size() {
        logger.finest("---EJBHashSet.size---");
        this.assertIsValid();
        this.assertInTransaction();
        return this.pcSet.size();
    }

    @Override
    public boolean isEmpty() {
        logger.finest("---EJBHashSet.isEmpty---");
        this.assertIsValid();
        this.assertInTransaction();
        return this.pcSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        logger.finest("---EJBHashSet.contains---");
        this.assertIsValid();
        this.assertInTransaction();
        this.helper.assertInstanceOfLocalInterfaceImpl(o);
        EJBLocalObject lo = (EJBLocalObject)o;
        return this.pcSet.contains(this.helper.convertEJBLocalObjectToPC(lo, this.pm, true));
    }

    @Override
    public boolean containsAll(Collection c) {
        logger.finest("---EJBHashSet.containsAll---");
        this.assertIsValid();
        this.assertInTransaction();
        this.assertInstancesOfLocalInterfaceImpl(c);
        return this.pcSet.containsAll(this.helper.convertCollectionEJBLocalObjectToPC(c, this.pm, true));
    }

    @Override
    public Object clone() {
        logger.finest("---EJBHashSet.clone---");
        EJBHashSet newSet = (EJBHashSet)super.clone();
        newSet.pcSet = (HashSet)this.pcSet.clone();
        return newSet;
    }

    public HashSet getSCOHashSet() {
        this.assertIsValid();
        this.assertInTransaction();
        return this.pcSet != null ? (HashSet)this.pcSet.clone() : null;
    }

    public void setSCOHashSet(Collection coll) {
        this.pcSet = coll instanceof HashSet ? (HashSet)coll : new HashSet(coll);
    }

    @Override
    public Iterator iterator() {
        this.assertIsValid();
        this.assertInTransaction();
        return new EJBHashIterator();
    }

    private void assertIsValid() {
        if (!this.valid) {
            throw new IllegalStateException();
        }
    }

    private void assertInTransaction() {
        if (this.pm.isClosed() || !this.tx.isActive()) {
            this.invalidate();
            throw new IllegalStateException();
        }
    }

    private void assertInstancesOfLocalInterfaceImpl(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.helper.assertInstanceOfLocalInterfaceImpl(it.next());
        }
    }

    public void invalidate() {
        this.valid = false;
        this.pm = null;
        this.tx = null;
        this.helper = null;
        this.pcSet = null;
    }

    private class EJBHashIterator
    implements Iterator {
        Iterator _iterator = null;
        Object lastReturned = null;

        EJBHashIterator() {
            this._iterator = EJBHashSet.this.pcSet.iterator();
        }

        @Override
        public boolean hasNext() {
            EJBHashSet.this.assertIsValid();
            EJBHashSet.this.assertInTransaction();
            return this._iterator.hasNext();
        }

        public Object next() {
            EJBHashSet.this.assertIsValid();
            EJBHashSet.this.assertInTransaction();
            try {
                this.lastReturned = this._iterator.next();
            }
            catch (ConcurrentModificationException e) {
                IllegalStateException ise = new IllegalStateException(e.toString());
                ise.initCause(e);
                throw ise;
            }
            return EJBHashSet.this.helper.convertPCToEJBLocalObject(this.lastReturned, EJBHashSet.this.pm);
        }

        @Override
        public void remove() {
            EJBHashSet.this.assertIsValid();
            EJBHashSet.this.assertInTransaction();
            try {
                this._iterator.remove();
            }
            catch (ConcurrentModificationException e) {
                IllegalStateException ise = new IllegalStateException(e.toString());
                ise.initCause(e);
                throw ise;
            }
        }
    }
}

