/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.glassfish.webservices.WsUtil;

public class JAXWSServiceDelegate
extends Service {
    private ServiceReferenceDescriptor serviceRef;
    private Service serviceDelegate;
    private URL wsdlLocation;
    private boolean fullWsdl = false;
    private static final int ADD_PORT = 1;
    private static final int CREATE_DISPATCH_CLASS = 2;
    private static final int CREATE_DISPATCH_CONTEXT = 3;
    private static final int GET_EXECUTOR = 4;
    private static final int SET_EXECUTOR = 5;
    private static final int GET_HANDLER_RESOLVER = 6;
    private static final int GET_PORT_CONTAINER_MANAGED = 7;
    private static final int GET_PORT_CLIENT_MANAGED = 8;
    private static final int GET_PORTS = 9;
    private static final int GET_SERVICE_NAME = 10;
    private static final int SET_HANDLER_RESOLVER = 11;
    private static final int GET_WSDL_LOCATION = 12;
    private static final int GENERATED_SERVICE_METHOD = 13;
    private static Map serviceMethodTypes;
    private static Set fullWsdlIllegalMethods;
    private static Set noWsdlIllegalMethods;

    public JAXWSServiceDelegate(ServiceReferenceDescriptor descriptor, Service delegate, ClassLoader loader) throws Exception {
        super(new WsUtil().privilegedGetServiceRefWsdl(descriptor), descriptor.getServiceName());
        this.serviceRef = descriptor;
        this.serviceDelegate = delegate;
        if (this.serviceRef.hasWsdlFile()) {
            this.wsdlLocation = new WsUtil().privilegedGetServiceRefWsdl(this.serviceRef);
            this.fullWsdl = true;
        }
    }

    public void addPort(QName q, String id, String addr) {
        this.checkUnsupportedMethods(1);
        this.serviceDelegate.addPort(q, id, addr);
    }

    public <T> Dispatch<T> createDispatch(QName qName, Class<T> aClass, Service.Mode mode) {
        this.checkUnsupportedMethods(2);
        return null;
    }

    public Dispatch<Object> createDispatch(QName qName, JAXBContext jaxbContext, Service.Mode mode) {
        this.checkUnsupportedMethods(3);
        return null;
    }

    public Executor getExecutor() {
        this.checkUnsupportedMethods(4);
        return this.serviceDelegate.getExecutor();
    }

    public void setExecutor(Executor obj) {
        this.checkUnsupportedMethods(5);
        this.serviceDelegate.setExecutor(obj);
    }

    public HandlerResolver getHandlerResolver() {
        this.checkUnsupportedMethods(6);
        return this.serviceDelegate.getHandlerResolver();
    }

    public Object getPort(QName q, Class sei) {
        this.checkUnsupportedMethods(8);
        return this.serviceDelegate.getPort(q, sei);
    }

    public Object getPort(Class sei) {
        this.checkUnsupportedMethods(7);
        String serviceEndpointInterface = sei.getName();
        ServiceRefPortInfo portInfo = this.serviceRef.getPortInfo(serviceEndpointInterface);
        Object retVal = portInfo != null && portInfo.hasWsdlPort() ? this.getPort(portInfo.getWsdlPort(), sei) : this.serviceDelegate.getPort(sei);
        return retVal;
    }

    public Iterator getPorts() {
        this.checkUnsupportedMethods(9);
        return this.serviceDelegate.getPorts();
    }

    public QName getServiceName() {
        this.checkUnsupportedMethods(10);
        return this.serviceRef.getServiceName();
    }

    public void setHandlerResolver(HandlerResolver resolver) {
        this.checkUnsupportedMethods(11);
        this.serviceDelegate.setHandlerResolver(resolver);
    }

    public URL getWSDLDocumentLocation() {
        this.checkUnsupportedMethods(11);
        return this.wsdlLocation;
    }

    private static void init() {
        serviceMethodTypes = new HashMap();
        fullWsdlIllegalMethods = new HashSet();
        noWsdlIllegalMethods = new HashSet();
        try {
            Class[] noParams = new Class[]{};
            Class<Service> serviceClass = Service.class;
            Method addPort = serviceClass.getDeclaredMethod("addPort", QName.class, URI.class, String.class);
            serviceMethodTypes.put(addPort, 1);
            Method createDispatchClass = serviceClass.getDeclaredMethod("createDispatch", QName.class, Class.class, Service.Mode.class);
            serviceMethodTypes.put(createDispatchClass, 2);
            Method createDispatchContext = serviceClass.getDeclaredMethod("createDispatch", QName.class, JAXBContext.class, Service.Mode.class);
            serviceMethodTypes.put(createDispatchContext, 3);
            Method getExecutor = serviceClass.getDeclaredMethod("getExecutor", noParams);
            serviceMethodTypes.put(getExecutor, 4);
            Method setExecutor = serviceClass.getDeclaredMethod("setExecutor", Executor.class);
            serviceMethodTypes.put(setExecutor, 5);
            Method getHandlerResolver = serviceClass.getDeclaredMethod("getHandlerResolver", noParams);
            serviceMethodTypes.put(getHandlerResolver, 6);
            Method getPortContainerManaged = serviceClass.getDeclaredMethod("getPort", Class.class);
            serviceMethodTypes.put(getPortContainerManaged, 7);
            Method getPortClientManaged = serviceClass.getDeclaredMethod("getPort", QName.class, Class.class);
            serviceMethodTypes.put(getPortClientManaged, 8);
            Method getPorts = serviceClass.getDeclaredMethod("getPorts", noParams);
            serviceMethodTypes.put(getPorts, 9);
            Method getServiceName = serviceClass.getDeclaredMethod("getServiceName", noParams);
            serviceMethodTypes.put(getServiceName, 10);
            Method setHandlerResolver = serviceClass.getDeclaredMethod("setHandlerResolver", HandlerResolver.class);
            serviceMethodTypes.put(setHandlerResolver, 11);
            Method getWsdlLocation = serviceClass.getDeclaredMethod("getWSDLDocumentLocation", noParams);
            serviceMethodTypes.put(getWsdlLocation, 12);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        noWsdlIllegalMethods.add(7);
        noWsdlIllegalMethods.add(8);
        noWsdlIllegalMethods.add(9);
        noWsdlIllegalMethods.add(10);
        noWsdlIllegalMethods.add(12);
        noWsdlIllegalMethods.add(13);
    }

    private void checkUnsupportedMethods(int methodType) throws UnsupportedOperationException {
        Set illegalMethods;
        Set set = illegalMethods = this.fullWsdl ? fullWsdlIllegalMethods : noWsdlIllegalMethods;
        if (illegalMethods.contains(methodType)) {
            throw new UnsupportedOperationException();
        }
    }

    static {
        JAXWSServiceDelegate.init();
    }
}

