/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.util.Arrays;
import org.glassfish.grizzly.Buffer;

final class IntegerWriter {
    private static final byte NEW = 0;
    private static final byte CONFIGURED = 1;
    private static final byte FIRST_BYTE_WRITTEN = 2;
    private static final byte DONE = 4;
    private byte state = 0;
    private int payload;
    private int N;
    private int value;

    IntegerWriter() {
    }

    public IntegerWriter configure(int value, int N, int payload) {
        if (this.state != 0) {
            throw new IllegalStateException("Already configured");
        }
        if (value < 0) {
            throw new IllegalArgumentException("value >= 0: value=" + value);
        }
        IntegerWriter.checkPrefix(N);
        this.value = value;
        this.N = N;
        this.payload = payload & 0xFF & -1 << N;
        this.state = 1;
        return this;
    }

    public boolean write(Buffer output) {
        if (this.state == 0) {
            throw new IllegalStateException("Configure first");
        }
        if (this.state == 4) {
            return true;
        }
        if (!output.hasRemaining()) {
            return false;
        }
        if (this.state == 1) {
            int max = (2 << this.N - 1) - 1;
            if (this.value < max) {
                output.put((byte)(this.payload | this.value));
                this.state = (byte)4;
                return true;
            }
            output.put((byte)(this.payload | max));
            this.value -= max;
            this.state = (byte)2;
        }
        if (this.state == 2) {
            while (this.value >= 128 && output.hasRemaining()) {
                output.put((byte)(this.value % 128 + 128));
                this.value /= 128;
            }
            if (!output.hasRemaining()) {
                return false;
            }
            output.put((byte)this.value);
            this.state = (byte)4;
            return true;
        }
        throw new InternalError(Arrays.toString(new Object[]{this.state, this.payload, this.N, this.value}));
    }

    private static void checkPrefix(int N) {
        if (N < 1 || N > 8) {
            throw new IllegalArgumentException("1 <= N <= 8: N= " + N);
        }
    }

    public IntegerWriter reset() {
        this.state = 0;
        return this;
    }
}

