/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.config.TrustSPMetadata;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.impl.IssueSamlTokenContract;
import com.sun.xml.ws.security.trust.impl.elements.str.KeyIdentifierImpl;
import com.sun.xml.ws.security.trust.impl.elements.str.SecurityTokenReferenceImpl;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.WSITXMLFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.callback.EncryptionKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.saml.Advice;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.AttributeStatement;
import com.sun.xml.wss.saml.AudienceRestriction;
import com.sun.xml.wss.saml.AudienceRestrictionCondition;
import com.sun.xml.wss.saml.AuthnContext;
import com.sun.xml.wss.saml.AuthnStatement;
import com.sun.xml.wss.saml.Conditions;
import com.sun.xml.wss.saml.KeyInfoConfirmationData;
import com.sun.xml.wss.saml.NameID;
import com.sun.xml.wss.saml.NameIdentifier;
import com.sun.xml.wss.saml.SAMLAssertionFactory;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.Subject;
import com.sun.xml.wss.saml.SubjectConfirmation;
import com.sun.xml.wss.saml.internal.saml20.jaxb20.SubjectType;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IssueSamlTokenContractImpl
extends IssueSamlTokenContract {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");

    @Override
    public Token createSAMLAssertion(String appliesTo, String tokenType, String keyType, String assertionId, String issuer, Map<QName, List<String>> claimedAttrs, IssuedTokenContext context) throws WSTrustException {
        X509Certificate serCert;
        GenericToken token = null;
        TrustSPMetadata spMd = this.stsConfig.getTrustSPMetadata(appliesTo);
        if (spMd == null) {
            spMd = this.stsConfig.getTrustSPMetadata("default");
        }
        if ((serCert = (X509Certificate)context.getOtherProperties().get("stsCertificate")) == null) {
            serCert = this.getServiceCertificate(spMd, appliesTo);
        }
        KeyInfo keyInfo = this.createKeyInfo(keyType, serCert, context, appliesTo);
        Assertion assertion = null;
        if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
            assertion = this.createSAML11Assertion(assertionId, issuer, appliesTo, keyInfo, claimedAttrs, keyType);
        } else if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            assertion = this.createSAML20Assertion(assertionId, issuer, appliesTo, keyInfo, claimedAttrs, keyType);
        } else {
            log.log(Level.SEVERE, LogStringsMessages.WST_0031_UNSUPPORTED_TOKEN_TYPE(tokenType, appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0031_UNSUPPORTED_TOKEN_TYPE(tokenType, appliesTo));
        }
        Object[] stsCertsAndPrikey = this.getSTSCertAndPrivateKey();
        X509Certificate stsCert = (X509Certificate)stsCertsAndPrikey[0];
        PrivateKey stsPrivKey = (PrivateKey)stsCertsAndPrikey[1];
        Element signedAssertion = null;
        try {
            signedAssertion = assertion.sign(stsCert, stsPrivKey, true, context.getSignatureAlgorithm(), context.getCanonicalizationAlgorithm());
        }
        catch (SAMLException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
        }
        if (this.stsConfig.getEncryptIssuedToken()) {
            String keyWrapAlgo = (String)context.getOtherProperties().get("keyWrapAlgorithm");
            Element encData = this.encryptToken(signedAssertion, serCert, appliesTo, context.getEncryptionAlgorithm(), keyWrapAlgo);
            token = new GenericToken(encData);
        } else {
            token = new GenericToken(signedAssertion);
        }
        return token;
    }

    private EncryptedKey encryptKey(Document doc, byte[] encryptedKey, X509Certificate cert, String appliesTo, String keyWrapAlgorithm) throws WSTrustException {
        EncryptedKey encKey = null;
        try {
            PublicKey pubKey = cert.getPublicKey();
            XMLCipher cipher = keyWrapAlgorithm != null ? XMLCipher.getInstance(keyWrapAlgorithm) : XMLCipher.getInstance("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
            cipher.init(3, pubKey);
            encKey = cipher.encryptKey(doc, new SecretKeySpec(encryptedKey, "AES"));
            KeyInfo keyinfo = new KeyInfo(doc);
            byte[] skid = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(cert);
            if (skid != null && skid.length > 0) {
                KeyIdentifierImpl keyIdentifier = new KeyIdentifierImpl("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier", null);
                keyIdentifier.setValue(Base64.encode(skid));
                SecurityTokenReferenceImpl str = new SecurityTokenReferenceImpl(keyIdentifier);
                keyinfo.addUnknownElement((Element)doc.importNode(WSTrustElementFactory.newInstance().toElement(str, null), true));
            } else {
                X509Data x509data = new X509Data(doc);
                x509data.addCertificate(cert);
                keyinfo.add(x509data);
            }
            encKey.setKeyInfo(keyinfo);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
            throw new WSTrustException(LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
        }
        catch (XMLEncryptionException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
            throw new WSTrustException(LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
        }
        catch (XMLSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
            throw new WSTrustException(LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
        }
        return encKey;
    }

    private Element encryptToken(Element assertion, X509Certificate serCert, String appliesTo, String encryptionAlgorithm, String keyWrapAlgorithm) throws WSTrustException {
        Element encDataEle = null;
        try {
            XMLCipher cipher = encryptionAlgorithm != null ? XMLCipher.getInstance(encryptionAlgorithm) : XMLCipher.getInstance("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            int keysizeInBytes = 32;
            byte[] skey = WSTrustUtil.generateRandomSecret(32);
            cipher.init(1, new SecretKeySpec(skey, "AES"));
            Document owner = assertion.getOwnerDocument();
            EncryptedData encData = cipher.encryptData(owner, assertion);
            String id = "uuid-" + UUID.randomUUID().toString();
            encData.setId(id);
            KeyInfo encKeyInfo = new KeyInfo(owner);
            EncryptedKey encKey = this.encryptKey(owner, skey, serCert, appliesTo, keyWrapAlgorithm);
            encKeyInfo.add(encKey);
            encData.setKeyInfo(encKeyInfo);
            encDataEle = cipher.martial(encData);
        }
        catch (XMLEncryptionException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0044_ERROR_ENCRYPT_ISSUED_TOKEN(appliesTo), ex);
            throw new WSTrustException(LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0044_ERROR_ENCRYPT_ISSUED_TOKEN(appliesTo), ex);
            throw new WSTrustException(LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
        }
        return encDataEle;
    }

    private X509Certificate getServiceCertificate(TrustSPMetadata spMd, String appliesTo) throws WSTrustException {
        String certAlias = spMd.getCertAlias();
        X509Certificate cert = null;
        CallbackHandler callbackHandler = this.stsConfig.getCallbackHandler();
        if (callbackHandler != null) {
            EncryptionKeyCallback.AliasX509CertificateRequest req = new EncryptionKeyCallback.AliasX509CertificateRequest(spMd.getCertAlias());
            EncryptionKeyCallback callback = new EncryptionKeyCallback(req);
            Callback[] callbacks = new Callback[]{callback};
            try {
                callbackHandler.handle(callbacks);
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
                throw new WSTrustException(LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
            }
            catch (UnsupportedCallbackException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
                throw new WSTrustException(LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
            }
            cert = req.getX509Certificate();
        } else {
            SecurityEnvironment secEnv = (SecurityEnvironment)this.stsConfig.getOtherOptions().get("SecurityEnvironment");
            try {
                cert = secEnv.getCertificate(this.stsConfig.getOtherOptions(), certAlias, false);
            }
            catch (XWSSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
                throw new WSTrustException(LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
            }
        }
        return cert;
    }

    private Object[] getSTSCertAndPrivateKey() throws WSTrustException {
        X509Certificate stsCert = null;
        PrivateKey stsPrivKey = null;
        CallbackHandler callbackHandler = this.stsConfig.getCallbackHandler();
        if (callbackHandler != null) {
            SignatureKeyCallback.DefaultPrivKeyCertRequest request = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
            SignatureKeyCallback skc = new SignatureKeyCallback(request);
            Callback[] callbacks = new Callback[]{skc};
            try {
                callbackHandler.handle(callbacks);
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0043_UNABLE_GET_STS_KEY(), ex);
                throw new WSTrustException(LogStringsMessages.WST_0043_UNABLE_GET_STS_KEY(), ex);
            }
            catch (UnsupportedCallbackException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0043_UNABLE_GET_STS_KEY(), ex);
                throw new WSTrustException(LogStringsMessages.WST_0043_UNABLE_GET_STS_KEY(), ex);
            }
            stsPrivKey = request.getPrivateKey();
            stsCert = request.getX509Certificate();
        } else {
            SecurityEnvironment secEnv = (SecurityEnvironment)this.stsConfig.getOtherOptions().get("SecurityEnvironment");
            try {
                stsCert = secEnv.getDefaultCertificate(this.stsConfig.getOtherOptions());
                stsPrivKey = secEnv.getPrivateKey(this.stsConfig.getOtherOptions(), stsCert);
            }
            catch (XWSSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0043_UNABLE_GET_STS_KEY(), ex);
                throw new WSTrustException(LogStringsMessages.WST_0043_UNABLE_GET_STS_KEY(), ex);
            }
        }
        Object[] results = new Object[]{stsCert, stsPrivKey};
        return results;
    }

    private KeyInfo createKeyInfo(String keyType, X509Certificate serCert, IssuedTokenContext ctx, String appliesTo) throws WSTrustException {
        Element kiEle = (Element)this.stsConfig.getOtherOptions().get("ConfirmationKeyInfo");
        if (kiEle != null) {
            try {
                return new KeyInfo(kiEle, null);
            }
            catch (XMLSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT(), ex);
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT(), ex);
            }
        }
        DocumentBuilderFactory docFactory = WSITXMLFactory.createDocumentBuilderFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
        Document doc = null;
        try {
            doc = docFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0039_ERROR_CREATING_DOCFACTORY(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0039_ERROR_CREATING_DOCFACTORY(), ex);
        }
        KeyInfo keyInfo = new KeyInfo(doc);
        if (this.wstVer.getSymmetricKeyTypeURI().equals(keyType)) {
            byte[] key = ctx.getProofKey();
            if (this.stsConfig.getEncryptIssuedKey()) {
                EncryptedKey encKey = this.encryptKey(doc, key, serCert, appliesTo, null);
                try {
                    keyInfo.add(encKey);
                }
                catch (XMLEncryptionException ex) {
                    log.log(Level.SEVERE, LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
                    throw new WSTrustException(LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
                }
            } else {
                BinarySecret secret = this.eleFac.createBinarySecret(key, this.wstVer.getSymmetricKeyTypeURI());
                Element bsEle = this.eleFac.toElement(secret, doc);
                keyInfo.addUnknownElement(bsEle);
            }
        } else if (this.wstVer.getPublicKeyTypeURI().equals(keyType)) {
            X509Data x509data = new X509Data(doc);
            try {
                x509data.addCertificate(ctx.getRequestorCertificate());
            }
            catch (XMLSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT(), ex);
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT(), ex);
            }
            keyInfo.add(x509data);
        }
        return keyInfo;
    }

    protected Assertion createSAML11Assertion(String assertionId, String issuer, String appliesTo, KeyInfo keyInfo, Map<QName, List<String>> claimedAttrs, String keyType) throws WSTrustException {
        Assertion assertion = null;
        try {
            Object statement;
            SAMLAssertionFactory samlFac = SAMLAssertionFactory.newInstance("Saml1.1");
            TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
            GregorianCalendar issuerInst = new GregorianCalendar(utcTimeZone);
            GregorianCalendar notOnOrAfter = new GregorianCalendar(utcTimeZone);
            notOnOrAfter.add(14, (int)this.stsConfig.getIssuedTokenTimeout());
            ArrayList<AudienceRestrictionCondition> arc = null;
            if (appliesTo != null) {
                arc = new ArrayList<AudienceRestrictionCondition>();
                ArrayList<String> au = new ArrayList<String>();
                au.add(appliesTo);
                arc.add(samlFac.createAudienceRestrictionCondition(au));
            }
            ArrayList<String> confirmMethods = new ArrayList<String>();
            String confirMethod = (String)this.stsConfig.getOtherOptions().get("Saml-Confirmation-Method");
            if (confirMethod == null) {
                confirMethod = keyType.equals(this.wstVer.getBearerKeyTypeURI()) ? "urn:oasis:names:tc:SAML:1.0:cm:bearer" : "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
            }
            Element keyInfoEle = null;
            if (keyInfo != null && !this.wstVer.getBearerKeyTypeURI().equals(keyType)) {
                keyInfoEle = keyInfo.getElement();
            }
            confirmMethods.add(confirMethod);
            SubjectConfirmation subjectConfirm = samlFac.createSubjectConfirmation(confirmMethods, null, keyInfoEle);
            Conditions conditions = samlFac.createConditions(issuerInst, notOnOrAfter, null, arc, null);
            Advice advice = samlFac.createAdvice(null, null, null);
            Subject subj = null;
            QName idName = null;
            Set<Map.Entry<QName, List<String>>> entries = claimedAttrs.entrySet();
            for (Map.Entry<QName, List<String>> entry : entries) {
                QName attrKey = entry.getKey();
                List<String> values = entry.getValue();
                if (values == null || values.size() <= 0 || !"NameID".equals(attrKey.getLocalPart()) || subj != null) continue;
                NameIdentifier nameId = samlFac.createNameIdentifier(values.get(0), attrKey.getNamespaceURI(), null);
                subj = samlFac.createSubject(nameId, subjectConfirm);
                idName = attrKey;
            }
            if (idName != null) {
                claimedAttrs.remove(idName);
            }
            ArrayList<Object> statements = new ArrayList<Object>();
            if (claimedAttrs.isEmpty()) {
                statement = samlFac.createAuthenticationStatement(null, issuerInst, subj, null, null);
                statements.add(statement);
            } else {
                statement = samlFac.createAttributeStatement(subj, null);
                statements.add(statement);
            }
            assertion = samlFac.createAssertion(assertionId, issuer, issuerInst, conditions, advice, statements);
            if (!claimedAttrs.isEmpty()) {
                return WSTrustUtil.addSamlAttributes(assertion, claimedAttrs);
            }
        }
        catch (SAMLException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
        }
        return assertion;
    }

    protected Assertion createSAML20Assertion(String assertionId, String issuer, String appliesTo, KeyInfo keyInfo, Map<QName, List<String>> claimedAttrs, String keyType) throws WSTrustException {
        Assertion assertion = null;
        try {
            SAMLAssertionFactory samlFac = SAMLAssertionFactory.newInstance("Saml2.0");
            TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
            GregorianCalendar issueInst = new GregorianCalendar(utcTimeZone);
            GregorianCalendar notOnOrAfter = new GregorianCalendar(utcTimeZone);
            notOnOrAfter.add(14, (int)this.stsConfig.getIssuedTokenTimeout());
            ArrayList<AudienceRestriction> arc = null;
            if (appliesTo != null) {
                arc = new ArrayList<AudienceRestriction>();
                ArrayList<String> au = new ArrayList<String>();
                au.add(appliesTo);
                arc.add(samlFac.createAudienceRestriction(au));
            }
            KeyInfoConfirmationData keyInfoConfData = null;
            String confirMethod = (String)this.stsConfig.getOtherOptions().get("Saml-Confirmation-Method");
            if (confirMethod == null) {
                if (keyType.equals(this.wstVer.getBearerKeyTypeURI())) {
                    confirMethod = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
                } else {
                    confirMethod = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
                    if (keyInfo != null) {
                        keyInfoConfData = samlFac.createKeyInfoConfirmationData(keyInfo.getElement());
                    }
                }
            }
            Conditions conditions = samlFac.createConditions(issueInst, notOnOrAfter, null, arc, null, null);
            SubjectConfirmation subjectConfirm = samlFac.createSubjectConfirmation(null, keyInfoConfData, confirMethod);
            Subject subj = null;
            QName idName = null;
            Set<Map.Entry<QName, List<String>>> entries = claimedAttrs.entrySet();
            for (Map.Entry<QName, List<String>> entry : entries) {
                QName attrKey = entry.getKey();
                List<String> values = entry.getValue();
                if (values == null || values.size() <= 0 || !"NameID".equals(attrKey.getLocalPart()) || subj != null) continue;
                NameID nameId = samlFac.createNameID(values.get(0), attrKey.getNamespaceURI(), null);
                subj = samlFac.createSubject(nameId, subjectConfirm);
                idName = attrKey;
            }
            if (idName != null) {
                claimedAttrs.remove(idName);
            }
            ArrayList<Object> statements = new ArrayList<Object>();
            if (claimedAttrs.isEmpty()) {
                AuthnContext ctx = samlFac.createAuthnContext(this.authnCtxClass, null);
                AuthnStatement statement = samlFac.createAuthnStatement(issueInst, null, ctx, null, null);
                statements.add(statement);
            } else {
                AttributeStatement statement = samlFac.createAttributeStatement(null);
                statements.add(statement);
            }
            NameID issuerID = samlFac.createNameID(issuer, null, null);
            assertion = samlFac.createAssertion(assertionId, issuerID, issueInst, conditions, null, null, statements);
            if (!claimedAttrs.isEmpty()) {
                assertion = WSTrustUtil.addSamlAttributes(assertion, claimedAttrs);
            }
            ((com.sun.xml.wss.saml.assertion.saml20.jaxb20.Assertion)assertion).setSubject((SubjectType)((Object)subj));
        }
        catch (SAMLException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
        }
        return assertion;
    }
}

