/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.ee.resources;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.osgi.ee.resources.Invalidate;

public class ResourceProxy
implements InvocationHandler,
Invalidate {
    private String jndiName;
    private boolean invalidated = false;

    public ResourceProxy(String jndiName) {
        this.jndiName = jndiName;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        if (method.getName().equals("invalidate")) {
            this.invalidate();
        } else {
            result = method.invoke(this.getActualObject(), args);
        }
        return result;
    }

    private Object getActualObject() {
        if (!this.invalidated) {
            try {
                return new InitialContext().lookup(this.jndiName);
            }
            catch (NamingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new RuntimeException("Resource [" + this.jndiName + "] is invalidated");
    }

    @Override
    public void invalidate() {
        this.invalidated = true;
    }
}

