/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import java.beans.PropertyVetoException;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.admin.restconnector.RestConfig;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="_set-rest-admin-config")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST)})
public class SetRestConfig
implements AdminCommand {
    @AccessRequired.To(value={"update"})
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    private ServiceLocator habitat;
    @Param(optional=true)
    private String debug;
    @Param(optional=true, defaultValue="-100")
    private int indentLevel;
    @Param(optional=true)
    private String wadlGeneration;
    @Param(optional=true)
    private String showHiddenCommands;
    @Param(optional=true)
    private String showDeprecatedItems;
    @Param(optional=true)
    private String logOutput;
    @Param(optional=true)
    private String logInput;
    @Param(optional=true)
    private String sessionTokenTimeout;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        RestConfig restConfig = (RestConfig)this.config.getExtensionByType(RestConfig.class);
        if (restConfig == null) {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                    public Object run(Config parent) throws TransactionFailure {
                        RestConfig child = (RestConfig)parent.createChild(RestConfig.class);
                        parent.getContainers().add(child);
                        return child;
                    }
                }, (ConfigBeanProxy)this.config);
            }
            catch (TransactionFailure e) {
                report.setMessage("TransactionFailure failure while creating the REST config");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)e);
                return;
            }
            restConfig = (RestConfig)this.config.getExtensionByType(RestConfig.class);
            if (restConfig == null) {
                report.setMessage("Rest Config is NULL...");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<RestConfig>(){

                public Object run(RestConfig param) throws TransactionFailure, PropertyVetoException {
                    if (SetRestConfig.this.debug != null) {
                        param.setDebug(SetRestConfig.this.debug);
                    }
                    if (SetRestConfig.this.indentLevel != -100) {
                        param.setIndentLevel("" + SetRestConfig.this.indentLevel);
                    }
                    if (SetRestConfig.this.showHiddenCommands != null) {
                        param.setShowHiddenCommands(SetRestConfig.this.showHiddenCommands);
                    }
                    if (SetRestConfig.this.showDeprecatedItems != null) {
                        param.setShowDeprecatedItems(SetRestConfig.this.showDeprecatedItems);
                    }
                    if (SetRestConfig.this.wadlGeneration != null) {
                        param.setWadlGeneration(SetRestConfig.this.wadlGeneration);
                    }
                    if (SetRestConfig.this.logOutput != null) {
                        param.setLogOutput(SetRestConfig.this.logOutput);
                    }
                    if (SetRestConfig.this.logInput != null) {
                        param.setLogInput(SetRestConfig.this.logInput);
                    }
                    if (SetRestConfig.this.sessionTokenTimeout != null) {
                        param.setSessionTokenTimeout(SetRestConfig.this.sessionTokenTimeout);
                    }
                    return param;
                }
            }, (ConfigBeanProxy)restConfig);
        }
        catch (TransactionFailure e) {
            report.setMessage("TransactionFailure while changing the REST config");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

