/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.util.OS;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;

public class JavaClassRunner {
    private static final File javaExe;

    public JavaClassRunner(String classpath, String[] sysprops, String classname, String[] args) throws IOException {
        if (javaExe == null) {
            throw new IOException("Can not find a jvm");
        }
        if (!this.ok(classname)) {
            throw new IllegalArgumentException("classname was null");
        }
        LinkedList<String> cmdline = new LinkedList<String>();
        cmdline.add(javaExe.getPath());
        if (this.ok(classpath)) {
            cmdline.add("-cp");
            cmdline.add(classpath);
        }
        if (sysprops != null) {
            for (String sysprop : sysprops) {
                cmdline.add(sysprop);
            }
        }
        cmdline.add(classname);
        if (args != null) {
            for (String arg : args) {
                cmdline.add(arg);
            }
        }
        ProcessBuilder pb = new ProcessBuilder(cmdline);
        Process p = pb.start();
        ProcessStreamDrainer.drain(classname, p);
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static {
        String javaName = "java";
        if (OS.isWindows()) {
            javaName = "java.exe";
        }
        String javaroot = System.getProperty("java.home");
        String relpath = "/bin/" + javaName;
        File fhere = new File(javaroot + relpath);
        File fthere = new File(javaroot + "/.." + relpath);
        javaExe = fhere.isFile() ? SmartFile.sanitize(fhere) : (fthere.isFile() ? SmartFile.sanitize(fthere) : null);
    }
}

