/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.glassfish.ejb.api.EjbEndpointFacade;
import org.glassfish.ejb.spi.WSEjbEndpointRegistry;
import org.glassfish.webservices.Ejb2RuntimeEndpointInfo;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.WebServiceContractImpl;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class WebServiceEjbEndpointRegistry
implements WSEjbEndpointRegistry {
    private static final Logger logger = LogUtils.getLogger();
    private final Map<String, EjbRuntimeEndpointInfo> webServiceEjbEndpoints = new ConcurrentHashMap<String, EjbRuntimeEndpointInfo>();
    private Set<String> ejbContextRoots = new HashSet<String>();
    private final Map<String, ServletAdapterList> adapterListMap = new HashMap<String, ServletAdapterList>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpoint(WebServiceEndpoint webserviceEndpoint, EjbEndpointFacade ejbContainer, Object servant, Class tieClass) {
        String uri = null;
        EjbRuntimeEndpointInfo endpoint = this.createEjbEndpointInfo(webserviceEndpoint, ejbContainer, servant, tieClass);
        Map<String, EjbRuntimeEndpointInfo> map = this.webServiceEjbEndpoints;
        synchronized (map) {
            String uriRaw = endpoint.getEndpointAddressUri();
            if (uriRaw != null) {
                String string = uri = uriRaw.charAt(0) == '/' ? uriRaw.substring(1) : uriRaw;
                if (this.webServiceEjbEndpoints.containsKey(uri)) {
                    logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00034", uri);
                }
                this.webServiceEjbEndpoints.put(uri, endpoint);
                this.regenerateEjbContextRoots();
                if (this.adapterListMap.get(uri) == null) {
                    ServletAdapterList list = new ServletAdapterList();
                    this.adapterListMap.put(uri, list);
                }
            } else {
                throw new WebServiceException(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00056"));
            }
        }
        WebServiceEngineImpl engine = WebServiceEngineImpl.getInstance();
        if (endpoint.getEndpoint().getWebService().getMappingFileUri() != null) {
            engine.createHandler(null, endpoint.getEndpoint());
        } else {
            engine.createHandler(endpoint.getEndpoint());
            try {
                endpoint.initRuntimeInfo(this.adapterListMap.get(uri));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "AS-WSJSR109IMPL-00088", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEndpoint(String endpointAddressUri) {
        EjbRuntimeEndpointInfo endpoint = null;
        Map<String, EjbRuntimeEndpointInfo> map = this.webServiceEjbEndpoints;
        synchronized (map) {
            String uriRaw = endpointAddressUri;
            String uri = uriRaw.charAt(0) == '/' ? uriRaw.substring(1) : uriRaw;
            ServletAdapterList list = this.adapterListMap.get(uri);
            if (list != null) {
                for (ServletAdapter x : list) {
                    x.getEndpoint().dispose();
                    for (Handler handler : x.getEndpoint().getBinding().getHandlerChain()) {
                        try {
                            WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
                            InjectionManager injManager = wscImpl.getInjectionManager();
                            injManager.destroyManagedObject((Object)handler);
                        }
                        catch (InjectionException e) {
                            logger.log(Level.WARNING, "AS-WSJSR109IMPL-00120", new Object[]{handler.getClass(), x.getEndpoint().getServiceName(), e.getMessage()});
                        }
                    }
                }
                this.adapterListMap.remove(uri);
            }
            endpoint = this.webServiceEjbEndpoints.remove(uri);
            this.regenerateEjbContextRoots();
        }
        if (endpoint == null) {
            return;
        }
        WebServiceEngineImpl engine = WebServiceEngineImpl.getInstance();
        engine.removeHandler(endpoint.getEndpoint());
    }

    public EjbRuntimeEndpointInfo createEjbEndpointInfo(WebServiceEndpoint webServiceEndpoint, EjbEndpointFacade ejbContainer, Object servant, Class tieClass) {
        EjbRuntimeEndpointInfo info = null;
        info = webServiceEndpoint.getWebService().hasMappingFile() ? new Ejb2RuntimeEndpointInfo(webServiceEndpoint, ejbContainer, servant, tieClass) : new EjbRuntimeEndpointInfo(webServiceEndpoint, ejbContainer, servant);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EjbRuntimeEndpointInfo getEjbWebServiceEndpoint(String uriRaw, String method, String query) {
        EjbRuntimeEndpointInfo endpoint = null;
        if (uriRaw == null || uriRaw.length() == 0) {
            return null;
        }
        String uri = uriRaw.charAt(0) == '/' ? uriRaw.substring(1) : uriRaw;
        Map<String, EjbRuntimeEndpointInfo> map = this.webServiceEjbEndpoints;
        synchronized (map) {
            String contextRoot;
            if (method.equals("GET") && this.ejbContextRoots.contains(contextRoot = this.getContextRootForUri(uri))) {
                for (EjbRuntimeEndpointInfo next : this.webServiceEjbEndpoints.values()) {
                    if (!next.getEndpoint().matchesEjbPublishRequest(uri, query)) continue;
                    endpoint = next;
                    break;
                }
            }
        }
        return endpoint != null ? endpoint : this.webServiceEjbEndpoints.get(uri);
    }

    public Collection getEjbWebServiceEndpoints() {
        return this.webServiceEjbEndpoints.entrySet();
    }

    private String getContextRootForUri(String uri) {
        StringTokenizer tokenizer = new StringTokenizer(uri, "/");
        if (tokenizer.hasMoreTokens()) {
            return tokenizer.nextToken();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regenerateEjbContextRoots() {
        Map<String, EjbRuntimeEndpointInfo> map = this.webServiceEjbEndpoints;
        synchronized (map) {
            HashSet<String> contextRoots = new HashSet<String>();
            for (String uri : this.webServiceEjbEndpoints.keySet()) {
                String contextRoot = this.getContextRootForUri(uri);
                if (contextRoot == null || contextRoot.equals("")) continue;
                contextRoots.add(contextRoot);
            }
            this.ejbContextRoots = contextRoots;
        }
    }
}

