/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.exception.TransactionManagementException;
import com.ibm.jbatch.container.transaction.impl.DefaultNonTransactionalManager;
import com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.ITransactionManagementService;
import com.ibm.jbatch.spi.services.TransactionManagerAdapter;
import java.util.logging.Logger;
import javax.batch.runtime.context.StepContext;

public class BatchTransactionServiceImpl
implements ITransactionManagementService {
    private static final String CLASSNAME = BatchTransactionServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IBatchConfig batchConfig = null;

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.entering(CLASSNAME, "init", batchConfig);
        this.batchConfig = batchConfig;
        logger.exiting(CLASSNAME, "init");
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
        logger.entering(CLASSNAME, "shutdown");
        logger.fine("do nothing");
        logger.exiting(CLASSNAME, "shutdown");
    }

    @Override
    public TransactionManagerAdapter getTransactionManager(StepContext stepContext) throws TransactionManagementException {
        logger.entering(CLASSNAME, "getTransactionManager", stepContext);
        TransactionManagerAdapter transactionManager = null;
        if (!this.batchConfig.isJ2seMode()) {
            logger.fine("getting transaction object from JNDI java:comp/UserTransaction");
            transactionManager = new JTAUserTransactionAdapter("java:comp/UserTransaction");
        } else if (this.batchConfig.isJ2seMode()) {
            logger.fine("J2SE mode non-transactional manager");
            transactionManager = new DefaultNonTransactionalManager();
        }
        logger.exiting(CLASSNAME, "getTransactionManager", transactionManager);
        return transactionManager;
    }
}

