/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.impl.BaseStepControllerImpl;
import com.ibm.jbatch.container.impl.BatchletStepControllerImpl;
import com.ibm.jbatch.container.impl.ChunkStepControllerImpl;
import com.ibm.jbatch.container.impl.DecisionControllerImpl;
import com.ibm.jbatch.container.impl.FlowControllerImpl;
import com.ibm.jbatch.container.impl.PartitionedStepControllerImpl;
import com.ibm.jbatch.container.impl.SplitControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.jsl.model.Batchlet;
import com.ibm.jbatch.jsl.model.Chunk;
import com.ibm.jbatch.jsl.model.Decision;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.Partition;
import com.ibm.jbatch.jsl.model.Split;
import com.ibm.jbatch.jsl.model.Step;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecutionElementControllerFactory {
    private static final String CLASSNAME = ExecutionElementControllerFactory.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);

    public static BaseStepControllerImpl getStepController(RuntimeJobExecution jobExecutionImpl, Step step, StepContextImpl stepContext, long rootJobExecutionId, BlockingQueue<PartitionDataWrapper> analyzerQueue) {
        Batchlet batchlet;
        Partition partition;
        String methodName = "getStepController";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASSNAME, methodName, "Get StepController for", step.getId());
        }
        if ((partition = step.getPartition()) != null) {
            if (partition.getMapper() != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASSNAME, methodName, "Found partitioned step with mapper", step);
                }
                return new PartitionedStepControllerImpl(jobExecutionImpl, step, stepContext, rootJobExecutionId);
            }
            if (partition.getPlan() != null && partition.getPlan().getPartitions() != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASSNAME, methodName, "Found partitioned step with plan", step);
                }
                return new PartitionedStepControllerImpl(jobExecutionImpl, step, stepContext, rootJobExecutionId);
            }
        }
        if ((batchlet = step.getBatchlet()) != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Found batchlet: " + batchlet + ", with ref= " + batchlet.getRef());
            }
            if (step.getChunk() != null) {
                throw new IllegalArgumentException("Step contains both a batchlet and a chunk.  Aborting.");
            }
            return new BatchletStepControllerImpl(jobExecutionImpl, step, stepContext, rootJobExecutionId, analyzerQueue);
        }
        Chunk chunk = step.getChunk();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Found chunk: " + chunk);
        }
        if (chunk == null) {
            throw new IllegalArgumentException("Step does not contain either a batchlet or a chunk.  Aborting.");
        }
        return new ChunkStepControllerImpl(jobExecutionImpl, step, stepContext, rootJobExecutionId, analyzerQueue);
    }

    public static DecisionControllerImpl getDecisionController(RuntimeJobExecution jobExecutionImpl, Decision decision) {
        return new DecisionControllerImpl(jobExecutionImpl, decision);
    }

    public static FlowControllerImpl getFlowController(RuntimeJobExecution jobExecutionImpl, Flow flow, long rootJobExecutionId) {
        return new FlowControllerImpl(jobExecutionImpl, flow, rootJobExecutionId);
    }

    public static SplitControllerImpl getSplitController(RuntimeJobExecution jobExecutionImpl, Split split, long rootJobExecutionId) {
        return new SplitControllerImpl(jobExecutionImpl, split, rootJobExecutionId);
    }
}

