/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.javamail.annotation.handler;

import com.sun.enterprise.deployment.MailSessionDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import javax.mail.MailSessionDefinition;
import javax.mail.MailSessionDefinitions;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.resources.javamail.annotation.handler.MailSessionDefinitionHandler;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=MailSessionDefinitions.class)
public class MailSessionDefinitionsHandler
extends AbstractResourceHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MailSessionDefinitionsHandler.class);

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        MailSessionDefinitions defns = (MailSessionDefinitions)ainfo.getAnnotation();
        MailSessionDefinition[] values = defns.value();
        HashSet<String> duplicates = new HashSet<String>();
        if (values != null && values.length > 0) {
            for (MailSessionDefinition defn : values) {
                String defnName = MailSessionDescriptor.getName((String)defn.name());
                if (duplicates.contains(defnName)) {
                    String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.mailsessiondefinitionsduplicates", "@MailSessionDefinitions cannot have multiple definitions with same name : ''{0}''", new Object[]{defnName});
                    throw new IllegalStateException(localString);
                }
                duplicates.add(defnName);
                MailSessionDefinitionHandler handler = new MailSessionDefinitionHandler();
                handler.processAnnotation(defn, ainfo, rcContexts);
            }
            duplicates.clear();
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }
}

