/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.model;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.TableElement;

public class ForeignFieldDesc
extends FieldDesc {
    public static final int ACT_CASCADE = 3;
    public static final int ACT_NONE = 0;
    public static final int ACT_NULLIFY = 1;
    public static final int ACT_RESTRICT = 2;
    public static final int ACT_AGGREGATE = 4;
    public ClassDesc foreignConfig;
    public int cardinalityLWB;
    public int cardinalityUPB;
    public int deleteAction;
    public ArrayList foreignFields;
    public ArrayList foreignColumns;
    public ArrayList localFields;
    public ArrayList localColumns;
    public ArrayList assocForeignFields;
    public ArrayList assocForeignColumns;
    public ArrayList assocLocalFields;
    public ArrayList assocLocalColumns;
    private ForeignFieldDesc inverseRelationshipField;
    private boolean isMappedToPk;

    ForeignFieldDesc(ClassDesc config) {
        super(config);
    }

    @Override
    public boolean isRelationshipField() {
        return true;
    }

    public boolean useJoinTable() {
        return this.assocLocalColumns != null && this.assocLocalColumns.size() > 0;
    }

    public boolean hasForeignKey() {
        boolean result = false;
        if (this.inverseRelationshipField != null) {
            result = this.cardinalityUPB == 1 && !this.useJoinTable() && (this.sqlProperties & 0x10) > 0;
        }
        return result;
    }

    public boolean isMappedToPk() {
        return this.isMappedToPk;
    }

    public ArrayList getLocalFields() {
        if (this.localFields == null) {
            this.localFields = new ArrayList();
        }
        return this.localFields;
    }

    public ArrayList getForeignFields() {
        if (this.foreignFields == null) {
            this.foreignFields = new ArrayList();
        }
        return this.foreignFields;
    }

    public ArrayList getAssocLocalFields() {
        if (this.assocLocalFields == null && this.assocLocalColumns != null) {
            this.assocLocalFields = new ArrayList();
        }
        return this.assocLocalFields;
    }

    public ArrayList getAssocForeignFields() {
        if (this.assocForeignFields == null && this.assocForeignColumns != null) {
            this.assocForeignFields = new ArrayList();
        }
        return this.assocForeignFields;
    }

    public ForeignFieldDesc getInverseRelationshipField() {
        return this.inverseRelationshipField;
    }

    public Object createObjectId(SQLStateManager sm, LocalFieldDesc fieldDesc, Object value) {
        assert (this.isMappedToPk());
        Class oidClass = this.foreignConfig.getOidClass();
        Object oid = null;
        try {
            oid = oidClass.newInstance();
        }
        catch (Exception e) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.statemanager.cantnewoid", (String)oidClass.getName()), e);
        }
        Field[] keyFields = this.foreignConfig.getKeyFields();
        String[] keyFieldNames = this.foreignConfig.getKeyFieldNames();
        for (int i = 0; i < keyFields.length && oid != null; ++i) {
            Field keyField = keyFields[i];
            for (int j = 0; j < this.foreignFields.size() && oid != null; ++j) {
                LocalFieldDesc fa = (LocalFieldDesc)this.foreignFields.get(j);
                if (fa.getName().compareTo(keyFieldNames[i]) != 0) continue;
                LocalFieldDesc la = (LocalFieldDesc)this.localFields.get(j);
                Object keyFieldValue = null;
                keyFieldValue = la == fieldDesc ? value : (sm.getSetMaskBit(la.absoluteID) && !sm.getSetMaskBit(this.absoluteID) ? la.getValue(sm.getBeforeImage()) : la.getValue(sm));
                if (keyFieldValue != null) {
                    try {
                        keyField.set(oid, fa.convertValue(keyFieldValue, sm));
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.statemanager.cantsetkeyfield", (String)keyField.getName()), (Exception)e);
                    }
                }
                oid = null;
            }
        }
        return oid;
    }

    private void setInverseRelationshipField(ForeignFieldDesc f) {
        this.inverseRelationshipField = f;
    }

    @Override
    void computeTrackedRelationshipFields() {
        ForeignFieldDesc inverseField = this.getInverseRelationshipField();
        for (int k = 0; k < this.classDesc.foreignFields.size(); ++k) {
            ForeignFieldDesc tf = (ForeignFieldDesc)this.classDesc.foreignFields.get(k);
            if (this == tf || this.getType() != tf.getType() || !ForeignFieldDesc.compareColumns(this, tf)) continue;
            if (inverseField != null && tf.getInverseRelationshipField() == null) {
                tf.setInverseRelationshipField(inverseField);
            }
            if ((this.sqlProperties & 0x40) == 0) {
                this.sqlProperties |= 0x20;
            }
            if ((tf.sqlProperties & 0x20) == 0) {
                tf.sqlProperties |= 0x40;
            }
            this.addTrackedField(tf);
        }
    }

    void fixupForeignReference(ClassDesc foreignConfig, ForeignFieldDesc inverseField) {
        this.registerForeignConfig(foreignConfig, inverseField);
        this.initializeFieldLists();
        this.initializeIsMappedToPk();
        this.addForeignKeyFieldsToDFG();
    }

    private void registerForeignConfig(ClassDesc foreignConfig, ForeignFieldDesc inverseField) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{this.classDesc, this, foreignConfig};
            logger.finest("sqlstore.model.classdesc.general", items);
        }
        this.foreignConfig = foreignConfig;
        if (debug && inverseField != null) {
            logger.finest("sqlstore.model.classdesc.assocrelatedfield", (Object)inverseField);
        }
        this.setInverseRelationshipField(inverseField);
    }

    private void initializeFieldLists() {
        ClassDesc theConfig = this.classDesc;
        for (int i = 0; i < 4; ++i) {
            ArrayList fields = null;
            ArrayList columns = null;
            switch (i) {
                case 0: {
                    columns = this.localColumns;
                    fields = this.getLocalFields();
                    break;
                }
                case 1: {
                    columns = this.assocLocalColumns;
                    fields = this.getAssocLocalFields();
                    break;
                }
                case 2: {
                    columns = this.assocForeignColumns;
                    fields = this.getAssocForeignFields();
                    break;
                }
                case 3: {
                    columns = this.foreignColumns;
                    fields = this.getForeignFields();
                    theConfig = this.foreignConfig;
                }
            }
            if (columns == null) continue;
            for (int j = 0; j < columns.size(); ++j) {
                ColumnElement ce = (ColumnElement)columns.get(j);
                TableElement te = ce.getDeclaringTable();
                if (te == null) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.configuration.columnnotable"));
                }
                fields.add(theConfig.getLocalFieldDesc(ce));
            }
        }
    }

    private void initializeIsMappedToPk() {
        int count = this.foreignFields.size();
        this.isMappedToPk = !this.useJoinTable() && this.foreignConfig.getKeyFields().length == count;
        for (int i = 0; i < count && this.isMappedToPk; ++i) {
            this.isMappedToPk = ((LocalFieldDesc)this.foreignFields.get(i)).isKeyField();
        }
    }

    private void addForeignKeyFieldsToDFG() {
        for (int i = 0; i < this.localFields.size(); ++i) {
            LocalFieldDesc lf = (LocalFieldDesc)this.localFields.get(i);
            if (lf.absoluteID >= 0 || this.useJoinTable()) continue;
            this.classDesc.getFetchGroup(1).add(lf);
        }
    }

    void fixupFieldProperties() {
        boolean refIntegrityUpdate = true;
        if (this.cardinalityUPB > 1) {
            refIntegrityUpdate = this.checkReferentialIntegrityUpdatesForCollectionField();
            if (!refIntegrityUpdate) {
                this.unsetReferentialIntegrityUpdateProperty();
                this.sqlProperties &= 0xFFFFFFFE;
            }
        } else {
            refIntegrityUpdate = this.checkReferentialIntegrityUpdatesForObjectField();
            if (!refIntegrityUpdate) {
                this.unsetReferentialIntegrityUpdateProperty();
                this.sqlProperties &= 0xFFFFFFFE;
            } else if (!this.useJoinTable()) {
                for (int i = 0; i < this.localFields.size(); ++i) {
                    ((LocalFieldDesc)this.localFields.get((int)i)).sqlProperties |= 0x400;
                }
            }
        }
        if (!refIntegrityUpdate) {
            this.unsetConcurrencyCheckProperty();
        }
    }

    private boolean checkReferentialIntegrityUpdatesForCollectionField() {
        ForeignFieldDesc inverseFieldDesc = this.getInverseRelationshipField();
        boolean refIntegrityUpdate = inverseFieldDesc == null ? this.defineUpdatedSideXToM() : (inverseFieldDesc.cardinalityUPB <= 1 ? false : this.defineUpdatedSideNToM(inverseFieldDesc));
        return refIntegrityUpdate;
    }

    private boolean checkReferentialIntegrityUpdatesForObjectField() {
        ForeignFieldDesc inverseFieldDesc = this.getInverseRelationshipField();
        boolean refIntegrityUpdate = inverseFieldDesc == null ? true : (inverseFieldDesc.cardinalityUPB > 1 ? true : this.defineUpdatedSide1To1(inverseFieldDesc));
        return refIntegrityUpdate;
    }

    private boolean defineUpdatedSideXToM() {
        boolean refIntegrityUpdate = this.useJoinTable();
        return refIntegrityUpdate;
    }

    private boolean defineUpdatedSideNToM(ForeignFieldDesc inverseFieldDesc) {
        boolean updateOtherSide = (inverseFieldDesc.sqlProperties & 0x10) > 0;
        boolean refIntegrityUpdate = !updateOtherSide ? true : this.chooseUpdatedSide(inverseFieldDesc);
        return refIntegrityUpdate;
    }

    private boolean defineUpdatedSide1To1(ForeignFieldDesc inverseFieldDesc) {
        boolean updateOtherSide;
        boolean bl = updateOtherSide = (inverseFieldDesc.sqlProperties & 0x10) > 0;
        boolean refIntegrityUpdate = !updateOtherSide ? true : (!this.useJoinTable() ? this.checkForeignKeysAndDependentSide(inverseFieldDesc) : this.checkDependentSide(inverseFieldDesc));
        if (!refIntegrityUpdate && this.cardinalityLWB == 1) {
            this.cardinalityLWB = 0;
        }
        return refIntegrityUpdate;
    }

    private boolean checkForeignKeysAndDependentSide(ForeignFieldDesc inverseFieldDesc) {
        boolean refIntegrityUpdate = ForeignFieldDesc.checkForeignKey(this.getLocalFields()) ? true : (ForeignFieldDesc.checkForeignKey(this.getForeignFields()) ? false : this.checkDependentSide(inverseFieldDesc));
        return refIntegrityUpdate;
    }

    private boolean checkDependentSide(ForeignFieldDesc inverseFieldDesc) {
        boolean refIntegrityUpdate = this.isDependentOn(inverseFieldDesc) ? true : (inverseFieldDesc.isDependentOn(this) ? false : (!this.useJoinTable() ? true : this.chooseUpdatedSide(inverseFieldDesc)));
        return refIntegrityUpdate;
    }

    private static boolean checkForeignKey(ArrayList fieldList) {
        for (int i = 0; i < fieldList.size(); ++i) {
            FieldDesc lf = (FieldDesc)fieldList.get(i);
            if ((lf.sqlProperties & 0x10) <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isDependentOn(ForeignFieldDesc inverseFieldDesc) {
        return this.cardinalityLWB == 1 || inverseFieldDesc.deleteAction == 3;
    }

    private boolean chooseUpdatedSide(ForeignFieldDesc inverseFieldDesc) {
        int comparison = this.classDesc.getName().compareTo(this.foreignConfig.getName());
        if (comparison == 0) {
            comparison = this.getName().compareTo(inverseFieldDesc.getName());
        }
        return comparison < 0;
    }

    private void unsetReferentialIntegrityUpdateProperty() {
        if (logger.isLoggable(300)) {
            logger.finest("sqlstore.model.classdesc.unsetrefintegrityupdate", (Object)this.getName());
        }
        this.sqlProperties &= 0xFFFFFFEF;
    }

    private void unsetConcurrencyCheckProperty() {
        ArrayList fieldList = (ArrayList)this.getLocalFields().clone();
        if (this.useJoinTable()) {
            fieldList.addAll(this.getAssocLocalFields());
        }
        for (int j = 0; j < fieldList.size(); ++j) {
            FieldDesc lf = (FieldDesc)fieldList.get(j);
            if (lf.absoluteID >= 0) continue;
            if (logger.isLoggable(300)) {
                logger.finest("sqlstore.model.classdesc.unsetconcurrencychk", (Object)lf.getName());
            }
            lf.sqlProperties &= 0xFFFFFFFE;
        }
    }
}

