/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.parser;

import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.parser.LogParser;
import com.sun.enterprise.server.logging.parser.LogParserException;
import com.sun.enterprise.server.logging.parser.LogParserListener;
import com.sun.enterprise.server.logging.parser.ParsedLogRecord;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Level;

public class RawLogParser
implements LogParser {
    private String streamName;

    public RawLogParser(String name) {
        this.streamName = name;
    }

    @Override
    public void parseLog(BufferedReader reader, LogParserListener listener) throws LogParserException {
        try {
            String line = null;
            long position = 0L;
            while ((line = reader.readLine()) != null) {
                ParsedLogRecord record = new ParsedLogRecord(line);
                record.setFieldValue("message", line);
                listener.foundLogRecord(position, record);
                ++position;
            }
        }
        catch (IOException e) {
            throw new LogParserException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LogFacade.LOGGING_LOGGER.log(Level.FINE, "Got exception while clsoing reader " + this.streamName, e);
                }
            }
        }
    }
}

