/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport;

import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.Utility;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageEvent;
import com.sun.enterprise.mgmt.transport.MessageImpl;
import com.sun.enterprise.mgmt.transport.MessageListener;
import com.sun.enterprise.mgmt.transport.NetworkManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractNetworkManager
implements NetworkManager {
    private static final Logger LOG = GMSLogDomain.getLogger("ShoalLogger");
    protected PeerID localPeerID;
    private final List<MessageListener> messageListeners = new CopyOnWriteArrayList<MessageListener>();

    @Override
    public void start() throws IOException {
    }

    @Override
    public void stop() throws IOException {
        this.messageListeners.clear();
    }

    @Override
    public void addMessageListener(MessageListener messageListener) {
        if (messageListener != null) {
            this.messageListeners.add(messageListener);
        }
    }

    @Override
    public void removeMessageListener(MessageListener messageListener) {
        if (messageListener != null) {
            this.messageListeners.remove(messageListener);
        }
    }

    @Override
    public void receiveMessage(Message message, Map piggyback) {
        PeerID sourcePeerID = null;
        PeerID targetPeerID = null;
        if (message != null) {
            Object element = message.getMessageElement("sourcePeerId");
            if (element instanceof PeerID) {
                sourcePeerID = (PeerID)element;
            }
            if ((element = message.getMessageElement("targetPeerId")) instanceof PeerID) {
                targetPeerID = (PeerID)element;
            }
        }
        if (sourcePeerID != null && !this.localPeerID.getGroupName().equals(sourcePeerID.getGroupName())) {
            return;
        }
        MessageEvent messageEvent = new MessageEvent(this, message, sourcePeerID, targetPeerID);
        try {
            this.beforeDispatchingMessage(messageEvent, piggyback);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "absnetmgr.beforefailed", t);
        }
        boolean messageEventNotProcessed = true;
        for (MessageListener listener : this.messageListeners) {
            if (message.getType() != listener.getType()) continue;
            try {
                messageEventNotProcessed = false;
                listener.receiveMessageEvent(messageEvent);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "failed to receive a message: type = ", new Object[]{message.getType()});
                LOG.log(Level.WARNING, "stack trace", t);
            }
        }
        if (messageEventNotProcessed && LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "No message listener for messageEvent: {0} Message :{1} MessageFrom: {2} MessageTo:{3}", new Object[]{messageEvent.toString(), message, sourcePeerID, targetPeerID});
        }
        try {
            this.afterDispatchingMessage(messageEvent, piggyback);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "absnetmgr.afterfailed", t);
        }
    }

    @Override
    public PeerID getLocalPeerID() {
        return this.localPeerID;
    }

    private static NetworkManager findByServiceLoader(String transport) {
        NetworkManager networkManager = null;
        ServiceLoader<NetworkManager> loader = ServiceLoader.load(NetworkManager.class);
        Iterator<NetworkManager> iter = loader.iterator();
        while (iter.hasNext()) {
            try {
                networkManager = (NetworkManager)iter.next().getClass().newInstance();
                if (!(transport.startsWith("grizzly") ? networkManager.getClass().getName().contains(transport) : transport.compareToIgnoreCase("jxta") == 0 && networkManager.getClass().getName().contains("Jxta"))) continue;
                break;
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "error instantiating NetworkManager service", t);
            }
        }
        if (networkManager == null) {
            LOG.log(Level.SEVERE, "fatal error, no NetworkManger implementations found");
        }
        return networkManager;
    }

    private static NetworkManager findByClassLoader(String classname) {
        NetworkManager networkManager = null;
        try {
            Class<?> networkManagerClass = Class.forName(classname);
            networkManager = (NetworkManager)networkManagerClass.newInstance();
        }
        catch (Throwable x) {
            LOG.log(Level.SEVERE, "fatal error instantiating NetworkManager service", x);
        }
        return networkManager;
    }

    public static NetworkManager getInstance(String transport) {
        NetworkManager networkManager = null;
        try {
            networkManager = AbstractNetworkManager.findByServiceLoader(transport);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (networkManager == null) {
            String classname = null;
            String GRIZZLY_TRANSPORT_BASE_DIR = "com.sun.enterprise.mgmt.transport.grizzly.";
            classname = transport.startsWith("grizzly2") ? "com.sun.enterprise.mgmt.transport.grizzly." + transport + ".GrizzlyNetworkManager2" : "com.sun.enterprise.mgmt.transport.jxta.JxtaNetworkManager";
            networkManager = AbstractNetworkManager.findByClassLoader(classname);
        }
        return networkManager;
    }

    protected abstract void beforeDispatchingMessage(MessageEvent var1, Map var2);

    protected abstract void afterDispatchingMessage(MessageEvent var1, Map var2);

    public static Logger getLogger() {
        return LOG;
    }

    @Override
    public synchronized void initialize(String groupName, String instanceName, Map properties) throws IOException {
        int maxMsgLength = Utility.getIntProperty(ServiceProviderConfigurationKeys.MAX_MESSAGE_LENGTH.toString(), 133120, properties);
        MessageImpl.setMaxMessageLength(maxMsgLength);
        if (LOG.isLoggable(Level.CONFIG)) {
            LOG.log(Level.CONFIG, "GMS MAX_MESSAGE_LENGTH={0}", maxMsgLength);
        }
    }
}

