/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecureAdminHelper;
import com.sun.enterprise.config.serverbeans.SecureAdminPrincipal;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.security.admin.cli.EnableSecureAdminCommand;
import com.sun.enterprise.security.admin.cli.SecureAdminCommand;
import com.sun.enterprise.security.ssl.SSLUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.KeyStoreException;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import javax.inject.Inject;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service
@PerLookup
public class SecureAdminUpgradeHelper {
    protected static final String DAS_CONFIG_NAME = "server-config";
    @Inject
    protected Domain domain;
    @Inject
    protected ServiceLocator habitat;
    @Inject
    protected StartupContext startupContext;
    private Transaction t = null;
    private SecureAdmin secureAdmin = null;
    private SecureAdminCommand.TopLevelContext topLevelContext = null;
    private SecureAdminHelper secureAdminHelper = null;
    private SSLUtils sslUtils = null;
    private Properties startupArgs = null;

    protected final Transaction transaction() {
        if (this.t == null) {
            this.t = new Transaction();
        }
        return this.t;
    }

    private SecureAdminCommand.TopLevelContext topLevelContext() {
        if (this.topLevelContext == null) {
            this.topLevelContext = new SecureAdminCommand.TopLevelContext(this.transaction(), this.domain);
        }
        return this.topLevelContext;
    }

    protected final void commit() throws RetryableException, TransactionFailure {
        if (this.t != null) {
            this.t.commit();
        }
    }

    protected final void rollback() {
        if (this.t != null) {
            this.t.rollback();
        }
    }

    protected final String specialAdminIndicator() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    protected final SecureAdmin secureAdmin() throws TransactionFailure {
        if (this.secureAdmin == null) {
            this.secureAdmin = this.domain.getSecureAdmin();
            if (this.secureAdmin == null) {
                this.secureAdmin = this.writableSecureAdmin();
                this.secureAdmin.setSpecialAdminIndicator(this.specialAdminIndicator());
            }
        }
        return this.secureAdmin;
    }

    protected final Domain writableDomain() throws TransactionFailure {
        return this.topLevelContext().writableDomain();
    }

    protected final SecureAdmin writableSecureAdmin() throws TransactionFailure {
        return this.topLevelContext().writableSecureAdmin();
    }

    protected final SecureAdminHelper secureAdminHelper() {
        if (this.secureAdminHelper == null) {
            this.secureAdminHelper = (SecureAdminHelper)this.habitat.getService(SecureAdminHelper.class, new Annotation[0]);
        }
        return this.secureAdminHelper;
    }

    protected final SSLUtils sslUtils() {
        if (this.sslUtils == null) {
            this.sslUtils = (SSLUtils)this.habitat.getService(SSLUtils.class, new Annotation[0]);
        }
        return this.sslUtils;
    }

    protected final void ensureSecureAdminReady() throws TransactionFailure, IOException, KeyStoreException {
        if (this.secureAdmin().getSpecialAdminIndicator().isEmpty()) {
            this.writableSecureAdmin().setSpecialAdminIndicator(this.specialAdminIndicator());
        }
        if (this.secureAdmin().getSecureAdminPrincipal().isEmpty() && this.secureAdmin().getSecureAdminInternalUser().isEmpty()) {
            this.addPrincipalForAlias(this.secureAdmin().dasAlias());
            this.addPrincipalForAlias(this.secureAdmin().instanceAlias());
        }
    }

    protected final String startupArg(String argName) {
        if (this.startupArgs == null) {
            this.startupArgs = this.startupContext != null ? this.startupContext.getArguments() : new Properties();
        }
        return this.startupArgs.getProperty(argName);
    }

    private void addPrincipalForAlias(String alias) throws IOException, KeyStoreException, TransactionFailure {
        SecureAdminPrincipal p = (SecureAdminPrincipal)this.writableSecureAdmin().createChild(SecureAdminPrincipal.class);
        p.setDn(this.secureAdminHelper().getDN(alias, true));
        this.writableSecureAdmin().getSecureAdminPrincipal().add(p);
    }

    protected final void ensureNonDASConfigsReady() throws TransactionFailure {
        Config c;
        Iterator iterator = this.domain.getConfigs().getConfig().iterator();
        while (iterator.hasNext() && ((c = (Config)iterator.next()).getName().equals(DAS_CONFIG_NAME) || this.ensureConfigReady(c))) {
        }
    }

    protected final void ensureDASConfigReady() {
    }

    private boolean ensureConfigReady(Config c) throws TransactionFailure {
        NetworkConfig nc = c.getNetworkConfig();
        if (nc == null) {
            return true;
        }
        Protocol secAdminProtocol = nc.getProtocols().findProtocol("sec-admin-listener");
        if (secAdminProtocol != null) {
            return true;
        }
        EnableSecureAdminCommand enableCmd = new EnableSecureAdminCommand();
        Config c_w = (Config)this.transaction().enroll((ConfigBeanProxy)c);
        SecureAdminCommand.ConfigLevelContext configLevelContext = new SecureAdminCommand.ConfigLevelContext(this.topLevelContext(), c_w);
        Iterator<SecureAdminCommand.Work<SecureAdminCommand.ConfigLevelContext>> it = enableCmd.perConfigSteps();
        while (it.hasNext()) {
            SecureAdminCommand.Work<SecureAdminCommand.ConfigLevelContext> step = it.next();
            if (step.run(configLevelContext)) continue;
            this.rollback();
            return false;
        }
        return true;
    }
}

