/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.deployment.annotation.handlers;

import com.sun.enterprise.connectors.jms.deployment.annotation.handlers.JMSConnectionFactoryDefinitionHandler;
import com.sun.enterprise.deployment.JMSConnectionFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import javax.jms.JMSConnectionFactoryDefinition;
import javax.jms.JMSConnectionFactoryDefinitions;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=JMSConnectionFactoryDefinitions.class)
public class JMSConnectionFactoryDefinitionsHandler
extends AbstractResourceHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JMSConnectionFactoryDefinitionsHandler.class);

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        JMSConnectionFactoryDefinitions defns = (JMSConnectionFactoryDefinitions)ainfo.getAnnotation();
        JMSConnectionFactoryDefinition[] values = defns.value();
        HashSet<String> duplicates = new HashSet<String>();
        if (values != null && values.length > 0) {
            for (JMSConnectionFactoryDefinition defn : values) {
                String defnName = JMSConnectionFactoryDefinitionDescriptor.getJavaName((String)defn.name());
                if (duplicates.contains(defnName)) {
                    String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.jmsconnectionfactorydefinitionsduplicates", "@JMSConnectionFactoryDefinition cannot have multiple definitions with same name : ''{0}''", new Object[]{defnName});
                    throw new IllegalStateException(localString);
                }
                duplicates.add(defnName);
                JMSConnectionFactoryDefinitionHandler handler = new JMSConnectionFactoryDefinitionHandler();
                handler.processAnnotation(defn, ainfo, rcContexts);
            }
            duplicates.clear();
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }
}

