/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.policy.wsrm200502;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.SimpleAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.rx.policy.AssertionInstantiator;
import com.sun.xml.ws.rx.rm.api.ReliableMessagingFeature;
import com.sun.xml.ws.rx.rm.api.ReliableMessagingFeatureBuilder;
import com.sun.xml.ws.rx.rm.api.RmAssertionNamespace;
import com.sun.xml.ws.rx.rm.api.RmProtocolVersion;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.policy.RmConfigurator;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public final class Rm10Assertion
extends SimpleAssertion
implements RmConfigurator {
    public static final QName NAME = RmProtocolVersion.WSRM200502.rmAssertionName;
    private static final QName INACTIVITY_TIMEOUT_QNAME = RmAssertionNamespace.WSRMP_200502.getQName("InactivityTimeout");
    private static final QName RETRANSMITTION_INTERVAL_QNAME = RmAssertionNamespace.WSRMP_200502.getQName("BaseRetransmissionInterval");
    private static final QName EXPONENTIAL_BACKOFF_QNAME = RmAssertionNamespace.WSRMP_200502.getQName("ExponentialBackoff");
    private static final QName MILISECONDS_ATTRIBUTE_QNAME = new QName("", "Milliseconds");
    private static AssertionInstantiator instantiator = new AssertionInstantiator(){

        @Override
        public PolicyAssertion newInstance(AssertionData data, Collection<PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) {
            return new Rm10Assertion(data, assertionParameters);
        }
    };
    private final long inactivityTimeout;
    private final long retransmittionInterval;
    private final boolean useExponentialBackoffAlgorithm;

    public static AssertionInstantiator getInstantiator() {
        return instantiator;
    }

    private Rm10Assertion(AssertionData data, Collection<? extends PolicyAssertion> assertionParameters) {
        super(data, assertionParameters);
        long _inactivityTimeout = 600000L;
        long _retransmittionInterval = 2000L;
        boolean _useExponentialBackoffAlgorithm = false;
        if (assertionParameters != null) {
            for (PolicyAssertion policyAssertion : assertionParameters) {
                if (INACTIVITY_TIMEOUT_QNAME.equals(policyAssertion.getName())) {
                    _inactivityTimeout = Long.parseLong(policyAssertion.getAttributeValue(MILISECONDS_ATTRIBUTE_QNAME));
                    continue;
                }
                if (RETRANSMITTION_INTERVAL_QNAME.equals(policyAssertion.getName())) {
                    _retransmittionInterval = Long.parseLong(policyAssertion.getAttributeValue(MILISECONDS_ATTRIBUTE_QNAME));
                    continue;
                }
                if (!EXPONENTIAL_BACKOFF_QNAME.equals(policyAssertion.getName())) continue;
                _useExponentialBackoffAlgorithm = true;
            }
        }
        this.inactivityTimeout = _inactivityTimeout;
        this.retransmittionInterval = _retransmittionInterval;
        this.useExponentialBackoffAlgorithm = _useExponentialBackoffAlgorithm;
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public long getBaseRetransmittionInterval() {
        return this.retransmittionInterval;
    }

    public boolean useExponentialBackoffAlgorithm() {
        return this.useExponentialBackoffAlgorithm;
    }

    @Override
    public ReliableMessagingFeatureBuilder update(ReliableMessagingFeatureBuilder builder) {
        if (builder.getProtocolVersion() != RmProtocolVersion.WSRM200502) {
            throw new WebServiceException(LocalizationMessages.WSRM_1002_MULTIPLE_WSRM_VERSIONS_IN_POLICY());
        }
        if (this.inactivityTimeout != 600000L) {
            builder.sequenceInactivityTimeout(this.inactivityTimeout);
        }
        if (this.inactivityTimeout != 2000L) {
            builder.messageRetransmissionInterval(this.retransmittionInterval);
        }
        if (this.useExponentialBackoffAlgorithm) {
            builder.retransmissionBackoffAlgorithm(ReliableMessagingFeature.BackoffAlgorithm.EXPONENTIAL);
        }
        return builder;
    }

    @Override
    public boolean isCompatibleWith(RmProtocolVersion version) {
        return RmProtocolVersion.WSRM200502 == version;
    }
}

