/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.soap;

import com.sun.xml.rpc.encoding.CombinedSerializer;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InterfaceSerializerBase;
import com.sun.xml.rpc.encoding.InternalEncodingConstants;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.namespace.QName;

public class CollectionInterfaceSerializer
extends InterfaceSerializerBase
implements Initializable,
InternalEncodingConstants {
    private CombinedSerializer vectorSerializer;
    private CombinedSerializer stackSerializer;
    private CombinedSerializer linkedListSerializer;
    private CombinedSerializer arrayListSerializer;
    private CombinedSerializer hashSetSerializer;
    private CombinedSerializer treeSetSerializer;
    private SOAPEncodingConstants soapEncodingConstants = null;

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public CollectionInterfaceSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle) {
        this(type, encodeType, isNullable, encodingStyle, SOAPVersion.SOAP_11);
    }

    public CollectionInterfaceSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, SOAPVersion ver) {
        super(type, encodeType, isNullable, encodingStyle);
        this.init(ver);
    }

    @Override
    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        this.vectorSerializer = (CombinedSerializer)registry.getSerializer(this.encodingStyle, Vector.class, QNAME_TYPE_VECTOR);
        this.vectorSerializer = this.vectorSerializer.getInnermostSerializer();
        this.stackSerializer = (CombinedSerializer)registry.getSerializer(this.encodingStyle, Stack.class, QNAME_TYPE_STACK);
        this.stackSerializer = this.stackSerializer.getInnermostSerializer();
        this.linkedListSerializer = (CombinedSerializer)registry.getSerializer(this.encodingStyle, LinkedList.class, QNAME_TYPE_LINKED_LIST);
        this.linkedListSerializer = this.linkedListSerializer.getInnermostSerializer();
        this.arrayListSerializer = (CombinedSerializer)registry.getSerializer(this.encodingStyle, ArrayList.class, QNAME_TYPE_ARRAY_LIST);
        this.arrayListSerializer = this.arrayListSerializer.getInnermostSerializer();
        this.hashSetSerializer = (CombinedSerializer)registry.getSerializer(this.encodingStyle, HashSet.class, QNAME_TYPE_HASH_SET);
        this.hashSetSerializer = this.hashSetSerializer.getInnermostSerializer();
        this.treeSetSerializer = (CombinedSerializer)registry.getSerializer(this.encodingStyle, TreeSet.class, QNAME_TYPE_TREE_SET);
        this.treeSetSerializer = this.treeSetSerializer.getInnermostSerializer();
    }

    @Override
    public Object doDeserialize(QName name, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        QName elementType = CollectionInterfaceSerializer.getType(reader);
        if (elementType.equals(QNAME_TYPE_COLLECTION) || elementType.equals(QNAME_TYPE_LIST) || elementType.equals(QNAME_TYPE_ARRAY_LIST)) {
            return this.arrayListSerializer.deserialize(name, reader, context);
        }
        if (elementType.equals(QNAME_TYPE_LINKED_LIST)) {
            return this.linkedListSerializer.deserialize(name, reader, context);
        }
        if (elementType.equals(QNAME_TYPE_VECTOR)) {
            return this.vectorSerializer.deserialize(name, reader, context);
        }
        if (elementType.equals(QNAME_TYPE_STACK)) {
            return this.stackSerializer.deserialize(name, reader, context);
        }
        if (elementType.equals(QNAME_TYPE_SET) || elementType.equals(QNAME_TYPE_HASH_SET)) {
            return this.hashSetSerializer.deserialize(name, reader, context);
        }
        if (elementType.equals(QNAME_TYPE_TREE_SET)) {
            return this.treeSetSerializer.deserialize(name, reader, context);
        }
        throw new DeserializationException("soap.unexpectedElementType", new Object[]{"", elementType.toString()});
    }

    @Override
    public void doSerializeInstance(Object obj, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        if (obj instanceof Stack) {
            this.stackSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof Vector) {
            this.vectorSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof ArrayList) {
            this.arrayListSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof LinkedList) {
            this.linkedListSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof HashSet) {
            this.hashSetSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof TreeSet) {
            this.treeSetSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof Set) {
            this.hashSetSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof List || obj instanceof Collection) {
            this.arrayListSerializer.serialize(obj, name, callback, writer, context);
        } else {
            throw new SerializationException("soap.cannot.serialize.type", obj.getClass().getName());
        }
    }
}

