/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.simpletype.EncoderUtils;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;

public class XSDFloatEncoder
extends SimpleTypeEncoderBase {
    private static final SimpleTypeEncoder encoder = new XSDFloatEncoder();

    private XSDFloatEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    @Override
    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        Float f = (Float)obj;
        float fVal = f.floatValue();
        if (f.isInfinite()) {
            if (fVal == Float.NEGATIVE_INFINITY) {
                return "-INF";
            }
            return "INF";
        }
        if (f.isNaN()) {
            return "NaN";
        }
        return f.toString();
    }

    @Override
    public Object stringToObject(String str, XMLReader reader) throws Exception {
        if (str == null) {
            return null;
        }
        if ((str = EncoderUtils.collapseWhitespace(str)).equals("-INF")) {
            return new Float(Float.NEGATIVE_INFINITY);
        }
        if (str.equals("INF")) {
            return new Float(Float.POSITIVE_INFINITY);
        }
        if (str.equals("NaN")) {
            return new Float(Float.NaN);
        }
        return new Float(str);
    }

    @Override
    public void writeValue(Object obj, XMLWriter writer) throws Exception {
        writer.writeCharsUnquoted(this.objectToString(obj, writer));
    }
}

