/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.common_impl;

import com.sun.enterprise.module.ModulesRegistry;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class TracingUtilities {
    private static final boolean enabled = Boolean.getBoolean("hk2.module.tracestate");

    public static boolean isEnabled() {
        return enabled;
    }

    public static File getLocation() {
        File f;
        String location = System.getProperty("hk2.module.loglocation");
        if (location == null) {
            location = System.getProperty("user.dir");
        }
        if ((f = new File(location)).isAbsolute()) {
            return f;
        }
        return new File(System.getProperty("user.dir"), location);
    }

    public static void traceResolution(ModulesRegistry registry, long bundleId, String bundleName, Loader loader) {
        TracingUtilities.traceState(registry, "resolved", bundleId, bundleName, loader);
    }

    public static void traceStarted(ModulesRegistry registry, long bundleId, String bundleName, Loader loader) {
        TracingUtilities.traceState(registry, "started", bundleId, bundleName, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceState(ModulesRegistry registry, String state, long bundleId, String bundleName, Loader loader) {
        File out = new File(TracingUtilities.getLocation(), state + "-" + bundleId + ".log");
        FileWriter w = null;
        try {
            w = new FileWriter(out);
            ((Writer)w).append("\n");
            ((Writer)w).append("Module [" + bundleId + "] " + state + " " + bundleName + "\n");
            String prefix = "-";
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            ((Writer)w).append("\n");
            ((Writer)w).append("-----------------------------------\n");
            ((Writer)w).append("Inhabitants / stack combination\n");
            ((Writer)w).append("-----------------------------------\n");
            String currentBundleName = bundleName;
            for (int i = 0; i < stack.length; ++i) {
                StackTraceElement caller;
                for (int j = i + 1; j < stack.length && (caller = stack[j]).getClassName().contains("hk2"); ++j) {
                }
            }
            ((Writer)w).append("\n");
            ((Writer)w).append("---------------------------\n");
            ((Writer)w).append("Complete thread stack Trace\n");
            ((Writer)w).append("---------------------------\n");
            for (StackTraceElement element : stack) {
                ((Writer)w).append(element.toString() + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (w != null) {
                try {
                    ((Writer)w).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface Loader {
        public Class loadClass(String var1) throws ClassNotFoundException;
    }
}

