/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import org.glassfish.appclient.server.core.jws.Util;

class LoaderConfigContent {
    private static final String OSGI_CONFIG_FILE_PATH = "config/osgi.properties";
    private final String content;

    LoaderConfigContent(File installDir) throws FileNotFoundException, IOException {
        this.content = this.loadContent(this.configFileURI(installDir));
    }

    String content() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadContent(URI configFileURI) throws FileNotFoundException, IOException {
        File configFile = new File(configFileURI);
        FileReader fr = new FileReader(configFile);
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1024];
        try {
            int charsRead;
            while ((charsRead = fr.read(buffer)) != -1) {
                String input = new String(buffer, 0, charsRead);
                sb.append(Util.toXMLEscapedInclAmp(input));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            fr.close();
        }
    }

    private URI configFileURI(File installDir) {
        return installDir.toURI().resolve(OSGI_CONFIG_FILE_PATH);
    }
}

