/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.glassfish.flashlight.impl.core.ProbeProviderRegistry;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ProbeRegistry {
    private static volatile ProbeRegistry _me = new ProbeRegistry();
    private static ConcurrentHashMap<Integer, FlashlightProbe> probeMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, FlashlightProbe> probeDesc2ProbeMap = new ConcurrentHashMap();

    public static ProbeRegistry getInstance() {
        return _me;
    }

    @Deprecated
    public static ProbeRegistry createInstance() {
        if (_me == null) {
            _me = new ProbeRegistry();
        }
        return _me;
    }

    public static void cleanup() {
        if (_me != null) {
            _me = new ProbeRegistry();
        }
        ProbeProviderRegistry.cleanup();
    }

    public void registerProbe(FlashlightProbe probe) {
        probeMap.put(probe.getId(), probe);
        probeDesc2ProbeMap.put(probe.getProbeDesc(), probe);
    }

    public void unregisterProbe(FlashlightProbe probe) {
        probeDesc2ProbeMap.remove(probe.getProbeDesc());
        probeMap.remove(probe.getId());
    }

    public void unregisterProbe(int id) {
        probeMap.remove(id);
    }

    public FlashlightProbe getProbe(int id) {
        return probeMap.get(id);
    }

    public FlashlightProbe getProbe(String probeStr) {
        return probeDesc2ProbeMap.get(probeStr);
    }

    public static FlashlightProbe getProbeById(int id) {
        return _me.getProbe(id);
    }

    public Collection<FlashlightProbe> getAllProbes() {
        Collection<FlashlightProbe> allProbes = probeMap.values();
        ArrayList<FlashlightProbe> visibleProbes = new ArrayList<FlashlightProbe>();
        for (FlashlightProbe probe : allProbes) {
            if (probe.isHidden()) continue;
            visibleProbes.add(probe);
        }
        return visibleProbes;
    }

    public static void invokeProbe(int id, Object[] args) {
        FlashlightProbe probe = probeMap.get(id);
        if (probe != null) {
            probe.fireProbe(args);
        }
    }

    public static Object invokeProbeBefore(int id, Object[] args) {
        FlashlightProbe probe = probeMap.get(id);
        if (probe != null) {
            return probe.fireProbeBefore(args);
        }
        return null;
    }

    public static void invokeProbeAfter(Object returnValue, int id, Object states) {
        FlashlightProbe probe = probeMap.get(id);
        if (probe != null) {
            try {
                probe.fireProbeAfter(returnValue, (ArrayList)states);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public static void invokeProbeOnException(Object exceptionValue, int id, Object states) {
        FlashlightProbe probe = probeMap.get(id);
        if (probe != null) {
            try {
                probe.fireProbeOnException(exceptionValue, (ArrayList)states);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

