/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.facelets;

import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.SyntaxException;
import com.sun.jsftemplating.layout.descriptors.ComponentType;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutComposition;
import com.sun.jsftemplating.layout.descriptors.LayoutDefine;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutElementBase;
import com.sun.jsftemplating.layout.descriptors.LayoutFacet;
import com.sun.jsftemplating.layout.descriptors.LayoutForEach;
import com.sun.jsftemplating.layout.descriptors.LayoutIf;
import com.sun.jsftemplating.layout.descriptors.LayoutInsert;
import com.sun.jsftemplating.layout.descriptors.LayoutStaticText;
import com.sun.jsftemplating.layout.facelets.DbFactory;
import com.sun.jsftemplating.layout.facelets.ParsingErrorHandler;
import com.sun.jsftemplating.layout.template.BaseProcessingContext;
import com.sun.jsftemplating.layout.template.EventParserCommand;
import com.sun.jsftemplating.layout.template.ProcessingContextEnvironment;
import com.sun.jsftemplating.layout.template.TemplateParser;
import com.sun.jsftemplating.layout.template.TemplateReader;
import com.sun.jsftemplating.util.IncludeInputStream;
import com.sun.jsftemplating.util.LayoutElementUtil;
import com.sun.jsftemplating.util.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FaceletsLayoutDefinitionReader {
    private URL url;
    private String key;
    private Document document;
    private int _idNumber;

    public FaceletsLayoutDefinitionReader(String key, URL url) {
        this._idNumber = LayoutElementUtil.getStartingIdNumber(null, key);
        InputStream is = null;
        BufferedInputStream bs = null;
        try {
            this.key = key;
            this.url = url;
            DocumentBuilder builder = DbFactory.getInstance();
            builder.setErrorHandler(new ParsingErrorHandler());
            is = this.url.openStream();
            bs = new BufferedInputStream(is);
            this.document = builder.parse(new IncludeInputStream(bs));
        }
        catch (Exception e) {
            try {
                throw new LayoutDefinitionException(e);
            }
            catch (Throwable throwable) {
                Util.closeStream(bs);
                Util.closeStream(is);
                throw throwable;
            }
        }
        Util.closeStream(bs);
        Util.closeStream(is);
    }

    public LayoutDefinition read() throws IOException {
        LayoutDefinition layoutDefinition = new LayoutDefinition(this.key);
        NodeList nodeList = this.document.getChildNodes();
        boolean abortProcessing = false;
        DocumentType docType = this.document.getDoctype();
        if (docType != null) {
            LayoutStaticText stDocType = new LayoutStaticText((LayoutElement)layoutDefinition, "", "<!DOCTYPE " + docType.getName() + " PUBLIC \"" + docType.getPublicId() + "\" \"" + docType.getSystemId() + "\">");
            layoutDefinition.addChildLayoutElement(stDocType);
        }
        for (int i = 0; i < nodeList.getLength() && !abortProcessing; ++i) {
            abortProcessing = this.process(layoutDefinition, nodeList.item(i), false);
        }
        return layoutDefinition;
    }

    public boolean process(LayoutElement parent, Node node, boolean nested) throws IOException {
        boolean abortProcessing = false;
        LayoutElement element = null;
        LayoutElement newParent = parent;
        boolean endElement = false;
        String value = node.getNodeValue();
        switch (node.getNodeType()) {
            case 3: {
                if (value.trim().equals("")) break;
                element = new LayoutStaticText(parent, LayoutElementUtil.getGeneratedId(node.getNodeName(), this.getNextIdNumber()), value);
                break;
            }
            case 1: {
                element = this.createComponent(parent, node, nested);
                if (element instanceof LayoutStaticText) {
                    endElement = true;
                    break;
                }
                if (element instanceof LayoutForEach) {
                    newParent = element;
                    break;
                }
                if (element instanceof LayoutIf) {
                    newParent = element;
                    break;
                }
                if (element instanceof LayoutComponent) {
                    nested = true;
                    newParent = element;
                    break;
                }
                if (element instanceof LayoutComposition) {
                    abortProcessing = ((LayoutComposition)element).isTrimming();
                    newParent = element;
                    break;
                }
                if (element instanceof LayoutDefine) {
                    newParent = element;
                    break;
                }
                if (element instanceof LayoutFacet) {
                    newParent = element;
                    break;
                }
                if (!(element instanceof LayoutInsert)) break;
                newParent = element;
                break;
            }
        }
        if (element != null) {
            parent.addChildLayoutElement(element);
            NodeList nodeList = node.getChildNodes();
            boolean abortChildProcessing = false;
            for (int i = 0; i < nodeList.getLength() && !abortChildProcessing; ++i) {
                abortChildProcessing = this.process(newParent, nodeList.item(i), nested);
            }
            if (abortChildProcessing) {
                abortProcessing = abortChildProcessing;
            } else if (endElement) {
                String nodeName = node.getNodeName();
                element = new LayoutStaticText(parent, LayoutElementUtil.getGeneratedId(nodeName, this.getNextIdNumber()), "</" + nodeName + ">");
                parent.addChildLayoutElement(element);
            }
        }
        return abortProcessing;
    }

    private LayoutComposition processComposition(LayoutElement parent, String attrName, NamedNodeMap attrs, String id, boolean trimming) {
        Node fileNameNode;
        LayoutComposition lc = new LayoutComposition(parent, id);
        lc.setTrimming(trimming);
        if (trimming) {
            parent = parent.getLayoutDefinition();
            parent.getChildLayoutElements().clear();
        }
        String fileName = (fileNameNode = attrs.getNamedItem(attrName)) != null ? fileNameNode.getNodeValue() : null;
        lc.setTemplate(fileName);
        return lc;
    }

    private LayoutComponent processComponent(LayoutElement parent, Node node, NamedNodeMap attrs, String id, boolean trimming) {
        if (trimming) {
            parent = parent.getLayoutDefinition();
            parent.getChildLayoutElements().clear();
        }
        LayoutComponent lc = new LayoutComponent(parent, id, LayoutDefinitionManager.getGlobalComponentType(null, "event"));
        parent.addChildLayoutElement(lc);
        LayoutComposition comp = this.processComposition(lc, "template", attrs, id + "_lc", trimming);
        NodeList nodeList = node.getChildNodes();
        boolean abortChildProcessing = false;
        for (int i = 0; i < nodeList.getLength() && !abortChildProcessing; ++i) {
            try {
                abortChildProcessing = this.process(comp, nodeList.item(i), true);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        lc.addChildLayoutElement(comp);
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LayoutElement createComponent(LayoutElement parent, Node node, boolean nested) {
        String id;
        LayoutElementBase element = null;
        String nodeName = node.getNodeName();
        NamedNodeMap attrs = node.getAttributes();
        Node nameNode = attrs.getNamedItem("id");
        String string = id = nameNode != null ? nameNode.getNodeValue() : LayoutElementUtil.getGeneratedId(nodeName, this.getNextIdNumber());
        if ("ui:composition".equals(nodeName)) {
            element = this.processComposition(parent, "template", attrs, id, true);
        } else if ("ui:decorate".equals(nodeName)) {
            element = this.processComposition(parent, "template", attrs, id, false);
        } else if ("ui:define".equals(nodeName)) {
            String name = attrs.getNamedItem("name").getNodeValue();
            element = new LayoutDefine(parent, name);
        } else if ("ui:insert".equals(nodeName)) {
            LayoutInsert li = new LayoutInsert(parent, id);
            Node nameAttr = attrs.getNamedItem("name");
            String name = nameAttr != null ? nameAttr.getNodeValue() : null;
            li.setName(name);
            element = li;
        } else if ("ui:component".equals(nodeName)) {
            element = this.processComponent(parent, node, attrs, id, true);
        } else if ("ui:fragment".equals(nodeName)) {
            element = this.processComponent(parent, node, attrs, id, false);
        } else if (!"ui:debug".equals(nodeName)) {
            if ("ui:include".equals(nodeName)) {
                element = this.processComposition(parent, "src", attrs, id, false);
            } else if ("ui:param".equals(nodeName)) {
                Node nameAttNode = attrs.getNamedItem("name");
                if (nameAttNode == null) {
                    throw new SyntaxException("The 'name' attribute is required on 'param'.");
                }
                Node valueNode = attrs.getNamedItem("value");
                if (valueNode == null) {
                    throw new SyntaxException("The 'value' attribute is required on 'param'.");
                }
                if (!(parent instanceof LayoutComposition)) {
                    throw new SyntaxException("<" + nodeName + " name='" + nameAttNode.getNodeValue() + "' value='" + valueNode.getNodeValue() + "'> must be child of a 'composition' element!");
                }
                ((LayoutComposition)parent).setParameter(nameAttNode.getNodeValue(), valueNode.getNodeValue());
            } else if (!"ui:remove".equals(nodeName) && !"ui:repeat".equals(nodeName)) {
                if ("ui:event".equals(nodeName)) {
                    String body = node.getTextContent();
                    body = body == null ? "/>" : body.trim() + "/>";
                    Node type = node.getAttributes().getNamedItem("type");
                    if (type == null) {
                        throw new SyntaxException("The 'type' attribute is required on 'ui:event'!");
                    }
                    String eventName = type.getNodeValue();
                    ByteArrayInputStream is = new ByteArrayInputStream(body.getBytes());
                    EventParserCommand command = new EventParserCommand();
                    try {
                        TemplateParser parser = new TemplateParser(is);
                        parser.open();
                        TemplateReader reader = new TemplateReader("foo", parser);
                        reader.pushTag("event");
                        command.process(new BaseProcessingContext(), new ProcessingContextEnvironment(reader, parent, true), eventName);
                        parser.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else if ("ui:if".equals(nodeName)) {
                    String condition = attrs.getNamedItem("condition").getNodeValue();
                    element = new LayoutIf(parent, condition);
                } else if ("ui:foreach".equals(nodeName)) {
                    Node valueNode = attrs.getNamedItem("value");
                    if (valueNode == null) {
                        throw new SyntaxException("The 'value' property is required on 'foreach'.");
                    }
                    Node varNode = attrs.getNamedItem("var");
                    if (varNode == null) {
                        throw new SyntaxException("The 'var' property is required on 'foreach'.");
                    }
                    element = new LayoutForEach(parent, valueNode.getNodeValue(), varNode.getNodeValue());
                } else if ("f:facet".equals(nodeName)) {
                    nameNode = attrs.getNamedItem("name");
                    if (nameNode == null) {
                        throw new IllegalArgumentException("You must provide a name attribute for all facets!  Parent component is: '" + parent.getUnevaluatedId() + "'.");
                    }
                    LayoutFacet facetElt = new LayoutFacet(parent, nameNode.getNodeValue());
                    boolean isRendered = !LayoutElementUtil.isNestedLayoutComponent(facetElt);
                    facetElt.setRendered(isRendered);
                    element = facetElt;
                } else {
                    LayoutComponent lc = null;
                    ComponentType componentType = null;
                    String nsURI = node.getNamespaceURI();
                    if (nsURI != null) {
                        componentType = LayoutDefinitionManager.getGlobalComponentType(null, nsURI + ':' + node.getLocalName());
                    }
                    if (componentType == null) {
                        componentType = LayoutDefinitionManager.getGlobalComponentType(null, nodeName);
                    }
                    if (componentType == null) {
                        String value = node.getNodeValue();
                        if (value == null) {
                            value = "";
                        }
                        lc = new LayoutStaticText(parent, id, "<" + nodeName + this.buildAttributeList(node) + ">");
                    } else {
                        lc = new LayoutComponent(parent, id, componentType);
                        this.addAttributesToComponent(lc, node);
                    }
                    lc.setNested(nested);
                    element = lc;
                }
            }
        }
        return element;
    }

    private void addAttributesToComponent(LayoutComponent lc, Node node) {
        NamedNodeMap map = node.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Node attr = map.item(i);
            lc.addOption(attr.getNodeName(), attr.getNodeValue());
        }
    }

    private String buildAttributeList(Node node) {
        StringBuilder attrs = new StringBuilder();
        NamedNodeMap map = node.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Node attr = map.item(i);
            attrs.append(" ").append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append("\"");
        }
        return attrs.toString();
    }

    public int getNextIdNumber() {
        LayoutElementUtil.incHighestId(this._idNumber);
        return this._idNumber++;
    }
}

