/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.descriptors;

import com.sun.jsftemplating.component.ChildManager;
import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.component.TemplateComponent;
import com.sun.jsftemplating.el.VariableResolver;
import com.sun.jsftemplating.layout.LayoutViewHandler;
import com.sun.jsftemplating.layout.ViewRootUtil;
import com.sun.jsftemplating.layout.descriptors.ComponentType;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutElementBase;
import com.sun.jsftemplating.layout.descriptors.LayoutFacet;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.layout.event.AfterCreateEvent;
import com.sun.jsftemplating.layout.event.AfterEncodeEvent;
import com.sun.jsftemplating.layout.event.BeforeCreateEvent;
import com.sun.jsftemplating.layout.event.BeforeEncodeEvent;
import com.sun.jsftemplating.util.LayoutElementUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class LayoutComponent
extends LayoutElementBase
implements LayoutElement {
    private static final long serialVersionUID = 1L;
    private ComponentType _type = null;
    private boolean _overwrite = false;
    private Map<String, Object> _options = new HashMap<String, Object>();
    public static final String AFTER_CREATE = "afterCreate";
    public static final String BEFORE_CREATE = "beforeCreate";
    public static final String COMMAND = "command";
    public static final String FACET_NAME = "_facetName";
    public static final String SKIP_ID_CHECK = "skipIdCheck";
    public static final String CLASS_NAME = LayoutComponent.class.getName();
    private boolean _nested = false;

    public LayoutComponent(LayoutElement parent, String id, ComponentType type) {
        super(parent, id);
        this._type = type;
    }

    public ComponentType getType() {
        return this._type;
    }

    public void setOverwrite(boolean value) {
        this._overwrite = value;
    }

    public boolean isOverwrite() {
        return this._overwrite;
    }

    public void addOption(String name, Object value) {
        this._options.put(name, value);
    }

    public void addOptions(Map<String, Object> map) {
        this._options.putAll(map);
    }

    public Object getOption(String name) {
        return this._options.get(name);
    }

    public Object getEvaluatedOption(FacesContext ctx, String name, UIComponent component) {
        Object value = this.getOption(name);
        return VariableResolver.resolveVariables(ctx, this, component, value);
    }

    public boolean containsOption(String name) {
        return this._options.containsKey(name);
    }

    public void setOptions(Map<String, Object> options) {
        this._options = options;
    }

    public Map<String, Object> getOptions() {
        return this._options;
    }

    @Override
    public void encode(FacesContext context, UIComponent parent) throws IOException {
        if (!this.getClass().getName().equals(CLASS_NAME)) {
            super.encode(context, parent);
            return;
        }
        if (this.isOverwrite()) {
            UIComponent child;
            String id = this.getId(context, parent);
            if (parent.getFacets().remove(id) == null && (child = ComponentUtil.getInstance(context).findChild(parent, id, null)) != null) {
                parent.getChildren().remove(child);
            }
        }
        UIComponent childComponent = null;
        childComponent = parent instanceof ChildManager ? ((ChildManager)parent).getChild(context, this) : this.getChild(context, parent);
        this.dispatchHandlers(context, "beforeEncode", new BeforeEncodeEvent(childComponent));
        if (parent instanceof TemplateComponent) {
            LayoutViewHandler.buildUIComponentTree(context, childComponent, this);
        }
        LayoutComponent.encodeChild(context, childComponent);
        this.dispatchHandlers(context, "afterEncode", new AfterEncodeEvent(childComponent));
    }

    @Override
    public boolean encodeThis(FacesContext context, UIComponent parent) throws IOException {
        return false;
    }

    public UIComponent getChild(FacesContext context, UIComponent parent) {
        UIComponent childComponent = null;
        String id = this.getId(context, parent);
        ComponentUtil compUtil = ComponentUtil.getInstance(context);
        childComponent = compUtil.findChild(parent, id, id);
        if (childComponent != null) {
            return childComponent;
        }
        this.beforeCreate(context, parent);
        childComponent = compUtil.createChildComponent(context, this, parent);
        this.afterCreate(context, childComponent);
        return childComponent;
    }

    @Override
    public List<Handler> getHandlers(String type, UIComponent comp) {
        List instHandlers;
        List<Handler> handlers = null;
        if (comp != null && (instHandlers = (List)comp.getAttributes().get(type)) != null && instHandlers.size() > 0) {
            handlers = new ArrayList<Handler>(instHandlers);
            List<Handler> defHandlers = this.getHandlers(type);
            if (defHandlers != null) {
                handlers.addAll(this.getHandlers(type));
            }
        }
        if (handlers == null) {
            handlers = this.getHandlers(type);
        }
        return handlers;
    }

    public Object beforeCreate(FacesContext context, UIComponent parent) {
        return this.dispatchHandlers(context, BEFORE_CREATE, new BeforeCreateEvent(parent));
    }

    public Object afterCreate(FacesContext context, UIComponent component) {
        return this.dispatchHandlers(context, AFTER_CREATE, new AfterCreateEvent(component));
    }

    public String getFacetName(UIComponent parent) {
        String name = null;
        name = (String)this.getOption(FACET_NAME);
        if (name != null && name.equals(this.getUnevaluatedId())) {
            name = null;
        }
        if (name == null) {
            for (LayoutElement parentElt = this.getParent(); parentElt != null; parentElt = parentElt.getParent()) {
                if (parentElt instanceof LayoutFacet) {
                    name = LayoutElementUtil.isLayoutComponentChild(parentElt) ? parentElt.getUnevaluatedId() : this.getUnevaluatedId();
                    if (name != null) break;
                    name = "_noname";
                    break;
                }
                if (!(parentElt instanceof LayoutComponent)) continue;
                return null;
            }
        }
        if (name == null) {
            if (parent instanceof TemplateComponent) {
                FacesContext ctx = FacesContext.getCurrentInstance();
                if (((TemplateComponent)parent).getLayoutDefinition(ctx) == this.getLayoutDefinition()) {
                    name = this.getUnevaluatedId();
                }
            } else if (parent instanceof UIViewRoot && ViewRootUtil.getLayoutDefinition((UIViewRoot)parent) != null) {
                name = this.getUnevaluatedId();
            }
        }
        return name;
    }

    public boolean isNested() {
        return this._nested;
    }

    public void setNested(boolean value) {
        this._nested = value;
    }
}

