/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli.internal;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-mcf-config-properties")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="get-mcf-config-properties", description="Get MCF Config Properties")})
public class GetMCFConfigProperties
implements AdminCommand {
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Param
    private String connectionDefnName;
    @Param
    private String rarName;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Map mcfConfigProps = this.connectorRuntime.getMCFConfigProps(this.rarName, this.connectionDefnName);
            Properties extraProperties = new Properties();
            extraProperties.put("mcfConfigProps", mcfConfigProps);
            List confidentialProperties = this.connectorRuntime.getConfidentialProperties(this.rarName, "ManagedConnectionFactory", new String[]{this.connectionDefnName});
            extraProperties.put("confidentialConfigProps", confidentialProperties);
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-mcf-config-properties failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

