/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JvmOptions {
    Map<String, String> sysProps = new HashMap<String, String>();
    Map<String, String> xxProps = new HashMap<String, String>();
    Map<String, String> xProps = new HashMap<String, String>();
    Map<String, String> plainProps = new HashMap<String, String>();
    int osgiPort = -1;

    JvmOptions(List<String> options) throws GFLauncherException {
        for (String s : options) {
            if ((s = StringUtils.removeEnclosingQuotes((String)s)).startsWith("-D")) {
                this.addSysProp(s);
                continue;
            }
            if (s.startsWith("-XX")) {
                this.addXxProp(s);
                continue;
            }
            if (s.startsWith("-X")) {
                this.addXProp(s);
                continue;
            }
            if (s.startsWith("-")) {
                this.addPlainProp(s);
                continue;
            }
            throw new GFLauncherException("UnknownJvmOptionFormat", s);
        }
        this.filter();
        this.setOsgiPort();
    }

    public String toString() {
        List<String> ss = this.toStringArray();
        StringBuilder sb = new StringBuilder();
        for (String s : ss) {
            sb.append(s).append('\n');
        }
        return sb.toString();
    }

    List<String> toStringArray() {
        String value;
        ArrayList<String> ss = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.xxProps.entrySet()) {
            value = entry.getValue();
            if (value != null) {
                ss.add("-XX" + entry.getKey() + "=" + value);
                continue;
            }
            ss.add("-XX" + entry.getKey());
        }
        for (Map.Entry<String, String> entry : this.xProps.entrySet()) {
            value = entry.getValue();
            if (value != null) {
                ss.add("-X" + entry.getKey() + "=" + value);
                continue;
            }
            ss.add("-X" + entry.getKey());
        }
        for (Map.Entry<String, String> entry : this.plainProps.entrySet()) {
            value = entry.getValue();
            if (value != null) {
                ss.add("-" + entry.getKey() + "=" + value);
                continue;
            }
            ss.add("-" + entry.getKey());
        }
        for (Map.Entry<String, String> entry : this.sysProps.entrySet()) {
            value = entry.getValue();
            if (value != null) {
                ss.add("-D" + entry.getKey() + "=" + value);
                continue;
            }
            ss.add("-D" + entry.getKey());
        }
        return this.postProcessOrdering(ss);
    }

    Map<String, String> getCombinedMap() {
        HashMap<String, String> all = new HashMap<String, String>(this.plainProps);
        all.putAll(this.xProps);
        all.putAll(this.xxProps);
        all.putAll(this.sysProps);
        return all;
    }

    int getOsgiPort() {
        return this.osgiPort;
    }

    private void addPlainProp(String s) {
        s = s.substring(1);
        NameValue nv = new NameValue(s);
        this.plainProps.put(nv.name, nv.value);
    }

    private void addSysProp(String s) {
        s = s.substring(2);
        NameValue nv = new NameValue(s);
        this.sysProps.put(nv.name, nv.value);
    }

    private void addXProp(String s) {
        s = s.substring(2);
        NameValue nv = new NameValue(s);
        this.xProps.put(nv.name, nv.value);
    }

    private void addXxProp(String s) {
        s = s.substring(3);
        NameValue nv = new NameValue(s);
        this.xxProps.put(nv.name, nv.value);
    }

    @Deprecated
    void addJvmLogging() {
        this.xxProps.put(":+UnlockDiagnosticVMOptions", null);
        this.xxProps.put(":+LogVMOutput", null);
        this.xxProps.put(":LogFile", "${com.sun.aas.instanceRoot}/logs/jvm.log");
    }

    @Deprecated
    void removeJvmLogging() {
        this.xxProps.remove(":+UnlockDiagnosticVMOptions");
        this.xxProps.remove(":+LogVMOutput");
        this.xxProps.remove(":LogFile");
    }

    private List<String> postProcessOrdering(List<String> unsorted) {
        ArrayList<String> sorted = new ArrayList<String>(unsorted.size());
        for (String s : unsorted) {
            if (!this.hasMagic(s)) continue;
            sorted.add(s);
        }
        for (String s : unsorted) {
            if (this.hasMagic(s)) continue;
            sorted.add(s);
        }
        return sorted;
    }

    private boolean hasMagic(String s) {
        String magic = "-XX:+Unlock";
        return s != null && s.startsWith("-XX:+Unlock");
    }

    private void filter() {
        String key = "javax.management.builder.initial";
        String forbiddenStart = "com.sun.enterprise";
        String forbiddenEnd = "AppServerMBeanServerBuilder";
        String val = this.sysProps.get("javax.management.builder.initial");
        if (val != null && val.startsWith("com.sun.enterprise") && val.endsWith("AppServerMBeanServerBuilder")) {
            this.sysProps.remove("javax.management.builder.initial");
        }
        if (OS.isDarwin() && System.getProperty("java.vm.vendor").equals("Apple Inc.")) {
            Pattern pattern = Pattern.compile("d\\d+");
            boolean settingPresent = false;
            for (String propName : this.plainProps.keySet()) {
                Matcher m = pattern.matcher(propName);
                if (!m.matches()) continue;
                settingPresent = true;
            }
            if (!settingPresent) {
                this.addPlainProp("-d32");
            }
        }
    }

    private void setOsgiPort() {
        String s = this.sysProps.get("osgi.shell.telnet.port");
        if (!StringUtils.ok((String)s)) {
            return;
        }
        try {
            this.osgiPort = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class NameValue {
        private String name;
        private String value;

        NameValue(String s) {
            int index = s.indexOf("=");
            if (index < 0) {
                this.name = s;
            } else {
                this.name = s.substring(0, index);
                if (index + 1 < s.length()) {
                    this.value = s.substring(index + 1);
                }
            }
        }
    }
}

