/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import java.util.HashMap;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.concurrent.admin.CreateManagedExecutorServiceBase;
import org.glassfish.concurrent.admin.ManagedScheduledExecutorServiceManager;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.jvnet.hk2.annotations.Service;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-managed-scheduled-executor-service")
@PerLookup
@I18n(value="create.managed.scheduled.executor.service")
public class CreateManagedScheduledExecutorService
extends CreateManagedExecutorServiceBase
implements AdminCommand {
    @Inject
    private Domain domain;
    @Inject
    private ManagedScheduledExecutorServiceManager managedScheduledExecutorServiceMgr;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        HashMap attrList = new HashMap();
        this.setAttributeList(attrList);
        try {
            rs = this.managedScheduledExecutorServiceMgr.create(this.domain.getResources(), attrList, this.properties, this.target);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.managed.scheduled.executor.service.failed", "Managed scheduled executor service {0} creation failed", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getMessage() != null) {
            report.setMessage(rs.getMessage());
        }
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        report.setActionExitCode(ec);
    }
}

