/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgihttp;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.security.common.PrincipalImpl;
import org.osgi.service.http.HttpContext;

public class OSGiSecurityValve
extends ValveBase {
    private HttpContext httpContext;

    public OSGiSecurityValve(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        if (this.httpContext.handleSecurity((HttpServletRequest)HttpServletRequest.class.cast(request), (HttpServletResponse)HttpServletResponse.class.cast(response))) {
            this.mapUser((HttpRequest)request);
            this.mapAuthType((HttpRequest)request);
            return 1;
        }
        return 2;
    }

    private void mapAuthType(HttpRequest httpRequest) {
        String authType = (String)httpRequest.getRequest().getAttribute("org.osgi.service.http.authentication.type");
        if (authType != null) {
            httpRequest.setAuthType(authType);
        }
    }

    private void mapUser(HttpRequest httpRequest) {
        String userName = (String)httpRequest.getRequest().getAttribute("org.osgi.service.http.authentication.remote.user");
        if (userName != null) {
            PrincipalImpl principal = new PrincipalImpl(userName);
            httpRequest.setUserPrincipal((Principal)principal);
        }
    }
}

