/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.sse;

import com.sun.enterprise.admin.remote.reader.ProprietaryReader;
import com.sun.enterprise.admin.remote.reader.ProprietaryReaderFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class GfSseInboundEvent {
    private String name = null;
    private String id = null;
    private ByteArrayOutputStream data = null;

    GfSseInboundEvent() {
    }

    void setName(String name) {
        this.name = name;
    }

    void setId(String id) {
        this.id = id;
    }

    void addData(byte[] data) {
        if (this.data == null) {
            this.data = new ByteArrayOutputStream();
        }
        try {
            this.data.write(data);
        }
        catch (IOException e) {
            this.data = null;
        }
    }

    boolean isEmpty() {
        return this.data == null;
    }

    public String getName() {
        return this.name;
    }

    public <T> T getData(Class<T> messageType, String contentType) throws IOException {
        ProprietaryReader<T> reader = ProprietaryReaderFactory.getReader(messageType, contentType);
        if (reader != null) {
            return reader.readFrom(new ByteArrayInputStream(this.stripLastLineBreak(this.data.toByteArray())), contentType);
        }
        return null;
    }

    public String getData() throws IOException {
        return this.getData(String.class, "text/plain");
    }

    public String toString() {
        String s;
        try {
            s = this.getData();
        }
        catch (IOException e) {
            s = "";
        }
        return "InboundEvent{name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", data=" + s + '}';
    }

    private byte[] stripLastLineBreak(byte[] data) {
        if (data.length >= 1 && data[data.length - 1] == 10) {
            byte[] newArray = new byte[data.length - 1];
            System.arraycopy(data, 0, newArray, 0, data.length - 1);
            data = newArray;
        }
        return data;
    }
}

