/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.util;

import com.sun.enterprise.container.common.impl.util.GlassFishObjectInputStream;
import com.sun.enterprise.container.common.impl.util.GlassFishObjectOutputStream;
import com.sun.enterprise.container.common.spi.util.GlassFishInputStreamHandler;
import com.sun.enterprise.container.common.spi.util.GlassFishOutputStreamHandler;
import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class JavaEEIOUtilsImpl
implements JavaEEIOUtils {
    private static Logger _logger = LogDomains.getLogger(JavaEEIOUtilsImpl.class, (String)"javax.enterprise.system.core.naming");
    @Inject
    ServiceLocator habitat;
    private Collection<GlassFishOutputStreamHandler> outputHandlers = new HashSet<GlassFishOutputStreamHandler>();
    private Collection<GlassFishInputStreamHandler> inputHandlers = new HashSet<GlassFishInputStreamHandler>();

    @Override
    public ObjectInputStream createObjectInputStream(InputStream is, boolean resolveObject, ClassLoader loader) throws Exception {
        return new GlassFishObjectInputStream(this.inputHandlers, is, loader, resolveObject);
    }

    @Override
    public ObjectOutputStream createObjectOutputStream(OutputStream os, boolean replaceObject) throws IOException {
        return new GlassFishObjectOutputStream(this.outputHandlers, os, replaceObject);
    }

    @Override
    public byte[] serializeObject(Object obj, boolean replaceObject) throws IOException {
        byte[] data = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = this.createObjectOutputStream(bos, replaceObject);
            oos.writeObject(obj);
            oos.flush();
            data = bos.toByteArray();
        }
        catch (NotSerializableException notSerEx) {
            throw notSerEx;
        }
        catch (Exception th) {
            IOException ioEx = new IOException(th.toString());
            ioEx.initCause(th);
            throw ioEx;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception exception) {}
            }
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
        return data;
    }

    @Override
    public Object deserializeObject(byte[] data, boolean resolveObject, ClassLoader appClassLoader) throws Exception {
        Object obj = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(data);
            ois = this.createObjectInputStream(bis, resolveObject, appClassLoader);
            obj = ois.readObject();
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Error during deserialization", ex);
            throw ex;
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception ex) {
                _logger.log(Level.FINEST, "Error during ois.close()", ex);
            }
            try {
                bis.close();
            }
            catch (Exception ex) {
                _logger.log(Level.FINEST, "Error during bis.close()", ex);
            }
        }
        return obj;
    }

    @Override
    public void addGlassFishOutputStreamHandler(GlassFishOutputStreamHandler handler) {
        this.outputHandlers.add(handler);
    }

    @Override
    public void removeGlassFishOutputStreamHandler(GlassFishOutputStreamHandler handler) {
        this.outputHandlers.remove(handler);
    }

    @Override
    public void addGlassFishInputStreamHandler(GlassFishInputStreamHandler handler) {
        this.inputHandlers.add(handler);
    }

    @Override
    public void removeGlassFishInputStreamHandler(GlassFishInputStreamHandler handler) {
        this.inputHandlers.remove(handler);
    }
}

